#ifndef _VUVOLUMECURVILINEARMULTIMODAL2D_H_
#define _VUVOLUMECURVILINEARMULTIMODAL2D_H_

#include "../multimodal.h"

class vu1321;
typedef vu1321 vuVolumeCurvilinearMultimodal2d;

/** this is the base class from which Curvilinear, multimodal, 2d renderers are derived.
This will provide the functionality to handle the range of the dataset in each dimension */
class vu1321 : public vu132
{
public:
	//! constructor
    vu1321();
    	//! copy constructor
    vu1321(vu1321& inst);
    	//! destructor
    virtual ~vu1321();

    	//! assignment operator
    vu1321& operator=(vu1321& rhs);


    	//! this will set the range of the first dimension of the dataset to be val
    void setDim1Size(int val);
    	//! this will return the range of the first dimension of the dataset
    int getDim1Size(void);
    	//! this will set the range of the second dimension of the dataset to be val
    void setDim2Size(int val);
    	//! this will return the range of the second dimension of the dataset
    int getDim2Size(void);

protected:
	//! this is the range of the first dimension of the dataset
    int m_Dim1Size;
	//! this is the range of the second dimension of the dataset
    int m_Dim2Size;

};

#endif
