#include "bcc.h"
#include <stdio.h>

//----------------------------------------------------------------------------
//------------------------- protected read() ---------------------------------
//----------------------------------------------------------------------------

bool vu15::read(FILE *file)
{
    int ret = 0;
    int len = 0;

    bool success = vu1::read(file);
    if (!success) return false;

    //Read in the Dataset type, checking if it's bcc
    ret = fscanf(file,"DATASET BCC_POINTS %n",&len);
    if (len < 19) return setInvalidFormatError();

    return true;
}

//----------------------------------------------------------------------------
//------------------------- protected write() --------------------------------
//----------------------------------------------------------------------------

bool vu15::write(FILE *file)
{
    int ret = 0;

    bool success = vu1::write(file);
    if (!success) return false;

    //Write the Dataset type
    ret = fprintf(file,"DATASET BCC_POINTS\n");
    
    if (ret > 0)
        return true;
    else
        return setWriteError();
}
