#include "unimodal.h"
#include <stdio.h>

//----------------------------------------------------------------------------
//------------------------- public getDataName() -----------------------------
//----------------------------------------------------------------------------

const char *vu151::getDataName(void) const
{
    return m_DataName.c_str();
}

//----------------------------------------------------------------------------
//------------------------- protected read() ---------------------------------
//----------------------------------------------------------------------------

bool vu151::read(FILE *file)
{
    int ret = 0;
    int len = 0;

    bool success = vu15::read(file);
    if (!success) return false;

    //Read in the modality of the data
    ret = fscanf(file,"UNIMODAL %n",&len);
    if (len < 9) return setInvalidFormatError();

    return true;
}

//----------------------------------------------------------------------------
//------------------------- protected write() --------------------------------
//----------------------------------------------------------------------------

bool vu151::write(FILE *file)
{
    int ret = 0;

    bool success = vu15::write(file);
    if (!success) return false;

    //Write the modality of the data
    ret = fprintf(file,"UNIMODAL\n");

    if (ret > 0)
        return true;
    else
        return setWriteError();
}
