#ifndef _VUVOLUMEBCCUNIMODAL3D_H_
#define _VUVOLUMEBCCUNIMODAL3D_H_

#include "../unimodal.h"

class vu1512;
typedef vu1512 vuVolumeBccUnimodal3d;

//!The base class for bcc unimodal 3d data in the vuVolume data tree.
class vu1512 : public vu151
{
public:
    //!The default constructor.
    vu1512();
    //!The copy constructor.
    vu1512(const vu1512& inst);

    //!The assignment operator.
    vu1512& operator=(const vu1512& rhs);

    //!Returns the size of the data along the first dimension.
    dword getDim1Size(void) const;
    //!Returns the size of the data along the second dimension.
    dword getDim2Size(void) const;
    //!Returns the size of the data along the third dimension.
    dword getDim3Size(void) const;

    //!Returns the spacing of the 3d grid.
    /*!This is the spacing between the data values in each of the dimensions.
       This value is uniform in all dimensions since this is a bcc grid.
    */
    dword getSpacing(void) const;

    //!Returns the origin of the data in the first dimension.
    int getDim1Origin(void) const;
    //!Returns the origin of the data in the second dimension.
    int getDim2Origin(void) const;
    //!Returns the origin of the data in the third dimension.
    int getDim3Origin(void) const;

    /**Returns the position of a point of given index.
       The position is relative to a cube of size
       getDim1Size x getDim2Size x getDim3Size. */
    vuVector getVoxelPosition(int x, int y, int z) const;

    //!returns the center of the dataset (virtual in volume.h)
    vuVector getCenter() const {
	return getVoxelPosition(m_Dim1Size, m_Dim2Size, m_Dim3Size)*0.5f;
    }

protected:
    //!Asserts that the file is 3d data and reads the associated information.
    /*!This method reads in the general information for 3d data sets.
       It also asserts whether the data is indeed 3d or not.
       \return True if successful (data is bcc), false otherwise.
    */
    virtual bool read(FILE *file);
    //!Writes the general 3d data information toe file.
    /*!\return True if successful, false otherwise.
    */
    virtual bool write(FILE *file);

    static const float T = 1.41421356;

protected:
    //!The size of the data set in the first dimension.
    dword m_Dim1Size;
    //!The size of the data set in the second dimension.
    dword m_Dim2Size;
    //!The size of the data set in the third dimension.
    dword m_Dim3Size;

    //!The spacing of the grid.
    dword m_Spacing;

    //!The origin of the data set in the first dimension.
    int m_Dim1Origin;
    //!The origin of the data set in the second dimension.
    int m_Dim2Origin;
    //!The origin of the data set in the third dimension.
    int m_Dim3Origin;
public:
    //!draws an OpenGl cube 
    void preview(int hint=0);

private:
    void drawBox(float sx, float sy, float sz);
};

#endif
