/*	Modified April 2002
	Modified by Christopher Steinbach

	Modified to remove the ios::nocreate flag in the
	SGI-IRIX compile because it doesn't seem to be
	available for the SGIs
*/

#ifndef _VUVOLUMEBCCUNIMODAL3D1B1THRESHOLDMARCHINGTETRAHEDRA_H_
#define _VUVOLUMEBCCUNIMODAL3D1B1THRESHOLDMARCHINGTETRAHEDRA_H_

#include "../threshold.h"
#include "glos.h"
#include <GL/gl.h>
#include <GL/glu.h>
#include "vuSimpleTypes.h"
#include "vuNormalTable.h"
#include "vuVector.h"

class vu1512121;
typedef vu1512121 vuVolumeBccUnimodal3d1BThresholdMarchingTetrahedra;

//!Implements a general splatter for this leaf of the tree.
/*!This class renders the volume using a general splatting method. The
   point of this splatter is to provide a general viewer that can be
   used for all purposes.  The most efficient splatters change the volume
   data to speed up rendering, and therefore cannot be used with multiple
   transfer functions.  The function of this splatter is to leave the
   volume data as is, while rendering as fast as possible.  This allows
   users to apply different transfer functions, and to write and look at
   the data after rendering it.

 \todo
    Find some way to add the ios::nocreate flag or some equivalent to this code
    so that we have similar behaviour in IRIX as we do Linux or Windows.
*/
class vu1512121 : public vu151212
{
public:
    //!Default constructor creating an empty instance.
    vu1512121();
    //!Copy constructor which does a deep copy.
    vu1512121(const vu1512121& inst);
    //!Destructor.
    virtual ~vu1512121();

    //!Assignment operator which does a deep copy.
    vu1512121& operator=(const vu1512121& rhs);

public:
    //!Sets the camera viewing position for the render method.
    void setViewVectors(const vuVector& view,const vuVector& up,const vuVector& right);

    //!Initializes open gl for rendering the volume data.
    void initOpenGL(void);
    //!Implements the abstract render() method of the vuVolume base class.
    void render();
    void DrawSurfaceInSimplex(int indices[4][3], float ht);
    void drawTriangle(float v1[3], float v2[3], float v3[3],
				 float n1[3], float n2[3], float n3[3], bool order);
    byte height(unsigned int x, unsigned int y, unsigned int z);
    void computeGradient(int i, int j, int k, float *g, int mode);
    void ComputeNormal(float *p, float *q, float *r, float *n);
    void InterpolatePoint(float x1, float y1, float z1, float h1, 	//	linear interpolation along an edge
			  float x2, float y2, float z2, float h2, 
			  float ht, float* result);

    long getNTriangles() { return nTriangles; };
    void resetNTriangles() { nTriangles = 0; };

    //!Reimplements the read() method to do some extra volume data processing.
    virtual bool read();
    
    //!This method reads volume data stored using the .raw data type.
    virtual bool readRaw(void);

private:
    int shading;
    long nTriangles;
    int printN;
    
    static const int WIRE = 0;
    static const int FLAT = 1;
    static const int SMOOTH = 2;

    vuVector     m_View;
    vuVector     m_Shift0;
    vuVector     m_Shift1;
    vuVector     m_Shift2;
};

#endif
