/*!Implements a bcc first hit raycaster
 Author:	Thomas Theussl
 Created:	Oct01

*/

#ifndef _VUVOLUMEBCCUNIMODAL3D1B1THRESHOLDFIRSTHITRAYCASTER_H_
#define _VUVOLUMEBCCUNIMODAL3D1B1THRESHOLDFIRSTHITRAYCASTER_H_

#include "../threshold.h"
#include "vuSimpleTypes.h"
#include "vuVector.h"
#include "vuMatrix.h"
#include "vuImage.h"

class vu1512122;
typedef vu1512122 vuVolumeBccUnimodal3d1BThresholdFirstHitRaycaster;

/** first hit raycaster for bcc grid
    images don't look pretty yet.
*/
class vu1512122 : public vu151212
{
 public:
  bool refresh;
  //!Default constructor creating an empty instance.
  vu1512122();
  //!Copy constructor which does a deep copy.
  vu1512122(const vu1512122& inst);
  //!Destructor.
  virtual ~vu1512122();

  //!Assignment operator which does a deep copy.
  vu1512122& operator=(const vu1512122& rhs);

 public:
  //!Sets the camera viewing position for the render method.
  void setViewVectors(const vuVector& view,const vuVector& up,const vuVector& right);

  //!Sets the size of the rendering canvas
  void setImageSize(int sx, int sy);

  /** Returns a pointer to the current image.
      Warning: The image (an it's dimensions) may change in the next resize or
      render operation. */
  vuImage *getImage() { return &m_Image; }

  //!Initializes open gl for rendering the volume data.
  void initOpenGL(void);
  //!Implements the abstract render() method of the vuVolume base class.
  void render();

  //!Reimplements the read() method to do some extra volume data processing.
  virtual bool read();
    
  //!This method reads volume data stored using the .raw data type.
  virtual bool readRaw(void);

  //!implementation of a virtual function
  void displayFromImage();

 private:
  //!Preprocesses volume data for rendering once it's been read.
  void preprocess(void);
  bool intersectRayWithBox(vuVector Ro, vuVector Rd, vuVector *f, vuVector *s, vuVector *llc, vuVector *urc);
  void renderImage();

 private:

  float*       m_Normals;

/*   vuVector     m_View; */
/*   vuVector     m_Shift0; */
/*   vuVector     m_Shift1; */
/*   vuVector     m_Shift2; */

  vuImage      m_Image;	//!< image (just an RGB byte framebuffer)
};

#endif
