#include <GL/gl.h>
#include <fstream.h>
#include <math.h>
#include "vuParallelCamera.h"
#include "vuPerspectiveCamera.h"

#include "firsthitraycaster.h"

//----------------------------------------------------------------------------
//------------------------- The default constructor --------------------------
//----------------------------------------------------------------------------

vu1512122::vu1512122()
{
  m_Camera = new vuPerspectiveCamera();
  m_Camera->setHeight(240);
  m_Camera->setWidth(320);
  refresh = false;
}

//----------------------------------------------------------------------------
//------------------------- The copy constructor -----------------------------
//----------------------------------------------------------------------------

vu1512122::vu1512122(const vu1512122& inst) : vu151212(inst)
{
}

//----------------------------------------------------------------------------
//------------------------- The destructor -----------------------------------
//----------------------------------------------------------------------------

vu1512122::~vu1512122()
{
}

//----------------------------------------------------------------------------
//------------------------- The assignment operator --------------------------
//----------------------------------------------------------------------------

vu1512122& vu1512122::operator=(const vu1512122& rhs)
{
    if (this != &rhs)
    {
        vu151212::operator=(rhs);

    }
    return *this;
}

void vu1512122::setImageSize(int sx, int sy) 
{
  if(m_Camera == NULL) {
      cerr << "no camera set" << endl;
      return;
  }
  if (m_Camera->getType() == vuCamera::vuPERSPECTIVE_CAMERA) {
    vuPerspectiveCamera *cptr = (vuPerspectiveCamera *)m_Camera;
    cptr->setAspect(float(sx)/sy);
  }
  m_Camera->setWidth(sx);
  m_Camera->setHeight(sy);
  m_Camera->init();
  m_Image.init(m_Camera->getWidth(),m_Camera->getHeight());
}

//----------------------------------------------------------------------------
//------------------------- public setViewVectors() --------------------------
//----------------------------------------------------------------------------

void vu1512122::setViewVectors(const vuVector& view,const vuVector& up,const vuVector& right)
{
//     m_View = view;
//     m_Shift1 = right*3.2f;
//     m_Shift2 = up*3.2f;
//     m_Shift0 = (m_Shift1+m_Shift2)*(-0.5f);

    // maybe we use the camera at some point (so far it's not used)
    m_Camera->setLookAtVector(view);
    m_Camera->setUpVector(up);
    m_Camera->setRightVector(right);
    m_Camera->init();
}

//----------------------------------------------------------------------------
//------------------------- public read() ------------------------------------
//----------------------------------------------------------------------------

bool vu1512122::read()
{
    bool success = vu151212::read();
    if (!success) return false;

    vuVector center(getCenter());
    m_Camera->setPosition(center);
    m_Camera->translateXYZ(0,0,-1.5f*(float)m_Dim1Size);
    m_Camera->init();

    preprocess();
    return true;
}

//----------------------------------------------------------------------------
//------------------------- public readRaw() ---------------------------------
//----------------------------------------------------------------------------

bool vu1512122::readRaw(void)
{
    dword len;
    ifstream in;

#ifdef IS_NOCREATE_NEEDED
    in.open(m_FileName, ios::in|ios::binary|ios::nocreate);
#else
	// The nocreate is not available on the IRIX boxes that we were compiling
	// this code on, so we had to remove this part from
    in.open(m_FileName, ios::in|ios::binary);
#endif

    if (!in.is_open()) return false;

    in.seekg(0, ios::end);
    len = in.tellg();
    in.seekg(0, ios::beg);

    in >> m_Dim1Size >> m_Dim2Size >> m_Dim3Size;
    if (in.fail()) return false;
    m_DataSize = m_Dim1Size*m_Dim2Size*m_Dim3Size;

    m_Data = new byte[m_DataSize];
    in.read((char *) (m_Data), int (m_DataSize));
    if (in.fail()) return false;

    in.close();

    preprocess();

    return true;
}

//----------------------------------------------------------------------------
//------------------------- private preprocess() -----------------------------
//----------------------------------------------------------------------------

void vu1512122::preprocess(void)
{
  // compute normals
  cout<<"preprocessing..."<<endl;
}

//----------------------------------------------------------------------------
//------------------------- public render() ----------------------------------
//----------------------------------------------------------------------------

void vu1512122::render(void)
{
  if (refresh)
    {
	glClearColor(0.0,0.0,0.0,0);
	glClear(GL_COLOR_BUFFER_BIT);
      

      renderImage();

      refresh = false;
    }
  displayFromImage();
  glFlush();
}

//----------------------------------------------------------------------------
//------------------------- public initOpenGL() ------------------------------
//----------------------------------------------------------------------------

void vu1512122::initOpenGL(void)
{
  //glEnable(GL_SECRET_FEATURE);
}

//----------------------------------------------------------------------------
//------------------------- private intersectRayWithBox() --------------------
//----------------------------------------------------------------------------

bool vu1512122::intersectRayWithBox(vuVector Ro, vuVector Rd, vuVector *f, vuVector *s, vuVector *llc, vuVector *urc)
{
  double tnear=-1.7E308,tfar=1.7E308,t1,t2;
  
  Rd.makeUnit();

  //
  // intersect ray with X slab
  //
  
  if (Rd[0] == 0.0)	// ray is parallel to YZ-plane
    {
      if ((Ro[0] < (*llc)[0]) || (Ro[0] > (*urc)[0]))
	return false;  //ray does not intersect data set
    }
  else
    {
      t1=((*llc)[0]-Ro[0])/Rd[0];
      t2=((*urc)[0]-Ro[0])/Rd[0];
      
      if (t1 < t2)
	{
	  tnear=t1;
	  tfar=t2;
	}
      else
	{
	  tnear=t2;
	  tfar=t1;
	}
    }
  
  //
  // intersect ray with Y slab
  //
  
  if (Rd[1] == 0.0)	// ray is parallel to XZ-plane
    {
      if ((Ro[1] < (*llc)[1]) || (Ro[1] > (*urc)[1]))
	return false;	// ray does not intersect data set
    }
  else
    {
      t1=((*llc)[1]-Ro[1])/Rd[1];
      t2=((*urc)[1]-Ro[1])/Rd[1];

      if (t1 > t2)
	{
	  double zw=t1;
	  t1=t2;
	  t2=zw;
	}
      
      if (t1 > tnear) tnear=t1;
      if (t2 < tfar)  tfar =t2;
      
      if (tfar < tnear)
	  return false;	// ray misses box
    }
  
  //
  // intersect ray with Z slab
  //
  
  if (Rd[2] == 0.0)	// ray is parallel to XY-plane
    {
      if ((Ro[2] < (*llc)[2]) || (Ro[2] > (*urc)[2]))
	return false; // ray does not intersect data set
    }
  else
    {
      t1=((*llc)[2]-Ro[2])/Rd[2];
      t2=((*urc)[2]-Ro[2])/Rd[2];
      
      if (t1 > t2)
	{
	  double zw=t1;
	  t1=t2;
	  t2=zw;
	}
      
      if (t1 > tnear) tnear=t1;
      if (t2 < tfar)  tfar =t2;
      
      if (tfar < tnear)
	  return false;	// ray misses box
    }

  vuVector Rd1(Rd);
  Rd *= tnear;
  *f = Ro + Rd;
  Rd1 *= tnear;
  *s = Ro + Rd;

  //PNT3 f1, s1;
  //VEC3 Rd1;
  //CopyVEC3(&Rd1,&Rd);
  //
  //MulVEC3Scal(&Rd,tnear);
  //AddPNT3VEC3(&f1,&Ro,&Rd);
  //
  //MulVEC3Scal(&Rd1,tfar);
  //AddPNT3VEC3(&s1,&Ro,&Rd1);
  //
  //(*f)[0] = f1.x;
  //(*f)[1] = f1.y;
  //(*f)[2] = f1.z;
  //
  //(*s)[0] = s1.x;
  //(*s)[1] = s1.y;
  //(*s)[2] = s1.z;

  return true;
}

//----------------------------------------------------------------------------
//------------------------- private renderImage() ----------------------------
//----------------------------------------------------------------------------

void vu1512122::renderImage()
{
  if(m_Camera == NULL) {
      cerr << "no camera found" << endl;
      return;
  }
  m_Image.init(m_Camera->getWidth(), m_Camera->getHeight());
    
//  double pz = 1.3;  // pseudo-zoom
//  float PI=3.14159265359;
  int XRES=m_Camera->getWidth();
  int YRES=m_Camera->getHeight();
  unsigned short maxx = m_Dim1Size, maxy = m_Dim2Size, maxz = m_Dim3Size;
/*
  vuVector p(-pz*double(maxx >> 1)        , -pz*double(maxy >> 1)         , -double(maxz >> 1)),
         dir( 0.0                         ,  0.0                          ,  0.42             ),
        down( 0.0                         ,  pz*double(maxy)/double(YRES) ,  0.0              ),
       right( pz*double(maxx)/double(XRES),  0.0                          ,  0.0              ),
      offset(-pz*double(maxx)             ,  0.0                          ,  0.0              );

  double alpha = PI/2.0, beta = 0.0;
  //double alpha = -PI/4.0, beta = PI/4.0;
  //double alpha = 0.0, beta = 0.0;

  float rot_values[16] = { cos(alpha)*cos(beta), sin(beta), -sin(alpha)*cos(beta), 0.0,
			  -cos(alpha)*sin(beta), cos(beta),  sin(alpha)*sin(beta), 0.0,
			   sin(alpha)          , 0        ,  cos(alpha)          , 0.0,
			   0.0                 , 0.0      , 0.0                  , 1.0};
            
  vuMatrix rot(rot_values);

       p *= rot;
     dir *= rot;
    down *= rot;
   right *= rot;
  offset *= rot;

  vuVector to_center(double(maxx >> 1), double(maxy >> 1), double(maxz >> 1));
  p += to_center;

*/

  vuVector l(m_Camera->getLookAtVector());
  l.makeUnit();

  vuVector dataSetLowerBound(0.0f, 0.0f, 0.0f);
  vuVector dataSetUpperBound((float)maxx, (float)maxy, (float)maxz);
  //vuVector dataSetUpperBound(64.0, 64.0, 64.0);

  vuVector *dslb = &dataSetLowerBound;
  vuVector *dsub = &dataSetUpperBound;

  //
  // shoot ray through each pixel
  //
/*
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glOrtho(0,XRES,0,YRES,-1,1);
*/    
  glBegin(GL_POINTS);
  for (int i=0; i<XRES; i++)
    {
      for (int j=0; j<YRES; j++)
	{
          vuRay ray(m_Camera->getRay((float)i,(float)j));
	  vuVector pos,pos2;

	  //double r_in = 0.0, g_in = 0.0, b_in = 0.0, a_in = 0.0,
	  // a_out, r, g, b, a;
	
	  double  r_out, g_out, b_out;
 
	  // traverse ray
	  //
	  
	  double th = 100.0;
	  double val = 0.0;

	  if (intersectRayWithBox(ray.m_Position, ray.m_Direction, &pos, &pos2, dslb, dsub))
	    {
		ray.m_Position = pos;
		ray.advance();

	      while ( (ray.m_Position[0] <= (*dsub)[0]) && (ray.m_Position[0] >= (*dslb)[0]) &&
		      (ray.m_Position[1] <= (*dsub)[1]) && (ray.m_Position[1] >= (*dslb)[1]) &&
		      (ray.m_Position[2] <= (*dsub)[2]) && (ray.m_Position[2] >= (*dslb)[2]) && (val < th) )
		{
		  val =getDataValue(ray.m_Position);
		  
		  ray.advance();
		}
	    } else ray.m_Position = pos;

	  if (val >= th)
	    {
	      vuVector grad = getGradient(ray.m_Position);
	      grad.makeUnit();
	      
	      double prod = fabs(grad.dot(l));
	      double d_s = 0.8*prod + 0.0*pow(prod,200.0);

	      r_out = d_s + 0.2;
	      g_out = d_s + 0.2;
	      b_out = d_s + 0.2;
	    }
	  else
	    {
	      r_out = 0.0;
	      g_out = 0.0;
	      b_out = 0.0;
	    }

	  vuColourRGBa col(r_out, g_out, b_out);
	  m_Image.set_xy(i,YRES-j, col);
	  //col.glColor();
	  ////glColor3f(r_out,g_out,b_out);
	  //glVertex2f(i,YRES-j);
	  
	  //p += right;
	}
      //printf("row %d\n",i);
      cout << "." << flush;

      //p += offset;
      //p += down;
    }
    glEnd();
}

void vu1512122::displayFromImage ()

{
  int mx, my;

  m_Image.get_extents (mx, my);

  if(mx && my)
      m_Image.blit();
  else
    cout << "bad" << endl;
}
