#ifndef _VUVOLUMEBCCUNIMODAL3D1BINTENSITY_H_
#define _VUVOLUMEBCCUNIMODAL3D1BINTENSITY_H_

#include "../1B.h"
#include "vuTFunc/vuTFIntensity.h"

class vu151211;
typedef vu151211 vuVolumeBccUnimodal3d1BIntensity;

//!The base class for visualization approaches using simple intensity transfer functions.
class vu151211 : public vu15121
{
public:
    //!Sets the transfer function for the instance.
    /*!Only the basic transfer function data is copied over, so other
       transfer function specific data is not stored.  Note that some
       rendering implementations, i.e. levels further down the tree,
       actually change the volume data based on the transfer function.
       In these cases, the transfer function must be set before
       the volume data is read, and should not be changed later on.
    */
    void setTransferFunc(const vuTFIntensity& tf);
    //!Returns the transfer function for the instance.
    const vuTFIntensity &getTransferFunc() const;

protected:
    //!The transfer function.
    vuTFIntensity m_TFunc;
};

#endif
