#include <iostream.h>
#include "FrameBuf16.h"
#include "SplatSlicer.h"

#define SHSP_SPLAT_SIZE		50
#define SHSP_MAXSPLATCROP	0.0	// full extension in z direction
#define SHSP_SPLATRADIUS	1.6
#define SHSP_SHEETWIDTH		1

//g++ pro.cpp -o pro -I ~/space/projects/vuVolume/proj/General SplatSlicer.cpp
/** calculates b to the power of e, with e being a positive integral value
  taking only log e multiplications
*/
float pow(float b, unsigned int e)
{
  float r = 1;
  while(e) {
    if(e&1) r*=b;
    b*=b;
    e=e>>1;
  }
  return r;
}

void main(void)
{
  RGBABuffer fb(6,6);
  RGBABuffer bb(6,6);
  AlphaMask ab;
  SplatSlicer m_Splat;
  m_Splat.buildSplat(SHSP_SPLATRADIUS,3,3,128);

  float vcol[4] = {1.0000, 0.0000, 1.0000, 1.00};
  float ccol[4] = {0.0f,0.0f,0.0f,0.0f};
  float col[4]  = {1.0f,0.0f,0.0f,0.5f};


  /*
  return true;
  ab.setSize(2,2);

  fb.clear(ccol);
  bb.clear(col);
  bb.print();
  fb.blendOver(bb,0,0);

  fb.print();
  col[2]= 1.;
  bb.clear(col);
  fb.blendOver(bb,0,0);
  cout<<"-------------------"<<endl;
  fb.print();
  

  return 1;
  */

  ab.clear(ccol);
  fb.clear(ccol);
  ccol[3] = 0;
  bb.clear(ccol);

  ColourRGBa rgbac(vcol);
  rgbac.setAlpha(1);
  fb.addColourWithM1subM2(m_Splat.getSpla(2), m_Splat.getSpla(-1),
				     rgbac,
				     0,0);
  m_Splat.getSpla(2).print();
  m_Splat.getSpla(-1).print();
  fb.print();
  cout<<"-------------------"<<endl;
  bb.blendOver(fb);
  bb.print();
  return 0;

  ab.clear(ccol);
  fb.clear(ccol);
  ccol[3] = 1;
  ccol[0] = .8;
  bb.clear(ccol);
  ab.getData()[2] = word(0.5*P2_16);
  printf("ab\n");
  ab.print();
  rgbac = col;
  fb.addColourWithMask(ab,rgbac,0,0);
  printf("fb\n");
  fb.print();
  bb.blendUnder(fb,0,0);
  printf("bb\n");
  bb.print();

  ccol[0] = 1;
  fb.clear(ccol);
  bb.blendUnder(fb,0,0);
  bb.print();
}
