#ifndef _SPLATSLICER_H_
#define _SPLATSLICER_H_

#include "vuSimpleTypes.h"
#include "FrameBuffer.h"

/** prepares preintegrated slices of a splatting kernel */
class SplatSlicer
{
 public:

  /** constructor */
  SplatSlicer();
  /** destructor */
  ~SplatSlicer();

  /** builds up preintegrated splats */
  bool buildSplat(float radius, int ysize, int xsize, int slices);

  /** returns a part of a splat integrated from 0 to t
      where t = 1.0 returns the complete splat
  */
  AlphaMask& getSpla(float t);

 protected:

  //!Computes splatting values using the Nelson algorithm. */
  double nelsonSplat(double r);

  //!integrates the Splat up to a certain slice
  float integrate(float r, float u);

  /** allocates memory for slices
      and sets up variables of this class
      \param nslices number of slices is z direction
      \param xsize,ysize width and height of splat
      \return success? */
  bool createSlices(int nslices, int xsize, int ysize);

  //! frees the memory occupied by the slices
  bool removeSlices();

  //----------------------------------- data -----------------------------------
  dword		m_NSlices; //!<number of slices to prepare
  dword		m_XSize, m_YSize; //!<
  float		m_Radius;//!< radius of a splat
  float		m_Diameter; //!<diameter of a splat
  AlphaMask	 *m_Slices;	//!< collection of preintegrated slices

};

#endif
