#include <iostream.h>
#include <math.h>
#include "vuSimpleTypes.h"
#include "SplatSlicer.h"

#ifdef WIN32
//! this is so that the code will compile
float erf (float x = 0.0, float y = 0.0)

{
	return 0.0;
}
#ifndef M_SQRT2
#define M_SQRT2 1.4142135624
#endif
#endif

SplatSlicer::SplatSlicer()
{
  m_Slices = NULL;
}

SplatSlicer::~SplatSlicer()
{
  removeSlices();
}

bool SplatSlicer::createSlices(int nslices, int xsize, int ysize)
{
  if(!removeSlices()) return false;
  if (!nslices || !xsize || !ysize) return false;
  m_Slices = new AlphaMask[nslices];
  if(!m_Slices) return false;
  int i;
  for(i=0;i<nslices;i++) {
    m_Slices[i].setSize(xsize, ysize);
  }
  m_NSlices = nslices;
  m_XSize = xsize;
  m_YSize = ysize;
  return true;
  
  
}

bool SplatSlicer::removeSlices()
{
  if(!m_Slices) return true;
  delete [] m_Slices;
  m_Slices = NULL;
  m_NSlices = 0;
  return true;
}

//----------------------------------------------------------------------------
//------------------------- private buildSplat() ---------------------------
//----------------------------------------------------------------------------

// this function calculates the slices in a wrong way, just for testing...
// will be fixed soon
bool SplatSlicer::buildSplat(float radius, int xsize, int ysize, int slices)
{
    if(!createSlices(slices, xsize, ysize)) return false;
    m_Radius = radius;
    m_Diameter = 2*radius;

    cout<<"building splats "<<xsize<<"x"<<ysize<<endl;
    dword index;
    dword i;
    dword j;
    double x;
    double y;
    double d;
    
    index = 0;
    int s;
    for(s=0;s<(int)m_NSlices;s++) {
      fbtype *data = m_Slices[s].getData();
      for(j=0;j<m_YSize;++j)
	{
	  for(i=0;i<m_XSize;++i)
	    {
	      x = 0.5 - (double)i/(double)(m_XSize-1);
	      y = 0.5 - (double)j/(double)(m_YSize-1);
	      d = sqrt(x*x+y*y);
	    
#ifdef FB_FLOAT
	      *(data++) = integrate(radius*d,
					   radius*(float(s)-float(m_NSlices/2))/m_NSlices);
#else
	      *(data++) = (word)(integrate(radius*d,
					   radius*(float(s)-float(m_NSlices/2))/m_NSlices)
				 *P2_16);
#endif	      
	    }
	}
    }
    return true;
}

float SplatSlicer::integrate(float r, float u)
{
  return float((0.223 * erf(M_SQRT2 * u) + 0.223) * exp(-2*r*r));
  //  return .2230000000f*erf(1.414213562f*u)*exp(-2.f*r*r)
  //  +.2230000000f*exp(-2.f*r*r);
}

AlphaMask& SplatSlicer::getSpla(float t)
{
  int slice = int((m_NSlices>>1) + ((t*m_NSlices)/(m_Diameter)));
  if(slice<0) slice = 0;
  else if(slice>=(int)m_NSlices) slice = m_NSlices-1;
  return m_Slices[slice];
}

