#ifndef _VUVOLUMEBCCUNIMODAL3D1B1VALSHEETSPLAT_H_
#define _VUVOLUMEBCCUNIMODAL3D1B1VALSHEETSPLAT_H_

#include "../intensity.h"
#include <GL/gl.h>
#include <GL/glu.h>
#include "vuSimpleTypes.h"
#include "vuNormalTable.h"
#include "vuVector.h"
#include "vuThread.h"
#include "vuParallelCamera.h"

#include "vuColourRGBa.h"
#include "FrameBuffer.h"
#include "SplatSlicer.h"

class vu1512112;
typedef vu1512112 vuVolumeBccUnimodal3d1B1ValSheetSplat;

//!Implements a sheet-based splatter for this leaf of the tree.
/*!
*/
class vu1512112 : public vu151211, public vuThread
{
public:
    //!Default constructor creating an empty instance.
    vu1512112();
    //!Destructor.
    virtual ~vu1512112();

    //!Assignment operator which does a deep copy.
    vu1512112& operator=(const vu1512112& rhs);

public:
    //!Sets the camera viewing position for the render method.
    void setViewVectors(const vuVector& view,const vuVector& up,const vuVector& right);

    //!Sets the size of the splatting footprint.
    void setFootprintSize(float size);
    //!Returns the size of the splatting footprint
    float getFootprintSize() const;
    //!sets the width of a slice
    void setSliceWidth(const float size);
    //!Returns the width of a slice
    float getSliceWidth() const;

    //!Initializes open gl for rendering the volume data.
    void initOpenGL(void);
    //!Implements the abstract render() method of the vuVolume base class.
    void render();

    //!Reimplements the read() method to do some extra volume data processing.
    virtual bool read();
    
    //!This method reads volume data stored using the .raw data type.
    virtual bool readRaw(void);

    vuVector getCenter() {return m_Center;}

    bool setImageSize(int width, int height);

    void setBGColour(float r, float g, float b);

    /** recalculate image 
	otherwise the existing framebuffer will be blitted to the screen
     */
    void doRefresh() { m_Refresh = true; }

private:
    //!overrides a virtual from vuThread allowing distributed rendering
    void run(int whatsup, void* data);

    //!Preprocesses volume data for rendering once it's been read.
    void preprocess(void);

    /** allocates setup number of sheets without memory for entries */
    void initSheets(float dist0, float ddist);

    /** allocates setup number of sheets without memory for entries */
    void prepareSheets();

    /** frees memory of bins */
    void clearSheets();

    /** sort voxels by distance 
	uses the eye position of the camera,
	dimensions of the dataset, thickness of the slices 
	and radius of splatting kernel to determine maximal number of slices
     */
    void sortByDistance();

    /** draws one slice to the back-buffer */
    void drawSlice(RGBABuffer& sheet, int n);

    void drawSlices();

    void showHistogram();
    
private:
    float		m_SplatRadius;		//!< size of a splat
    float		m_SliceWidth;		//!< width of a slice
    dword		m_SpS_2;		//!< ((slices per splat) / 2)_
    float		m_SplatCrop;		//!< depth tolerance below which splat in slice is ignored 
    int			m_NSlices;		//!< number of slices
    dword		**m_Slices;		//!< index bucket for each slice ([0] is N of elements)
    float		*m_SliceDist;		//!< distance of each single slice
    float		*m_SplatPos;		//!< projected coordinates with distance in 3rd component
    bool		m_Exclude[256];		//!< exclude intensities from rendering
//! stores three normal components per voxel
    vuVector		*m_Normals;
    /** stores two shading coefficients per voxel
	first is diffuse l*n, second is specular (r*v)^shin */
    float		*m_Shading;		
    SplatSlicer		m_Splat;
    int			m_FBWidth, m_FBHeight;
    RGBABuffer		m_FrameBuffer;
    RGBABuffer		m_SheetBuffer;
    vuVector		m_Center;
    float		m_BGColour[4];		//!< background colour 

    vuColourRGBa	m_LightSpecular;	//!< specular colour with alpha weight
    float		m_LightDiffuse;		//!< weight for diffuse relection
    float		m_LightAmbient;		//!< weight for ambient
    unsigned int	m_LightShininess;	//!< exponent for shininess
    vuVector		m_LightDir;		//!< direction for parallel light

    int			m_CurrentSheet;
    vuMutex		m_FBMutex;
    
    bool		m_DataPrepared;
    bool		m_Refresh;		//!< calculate new image
};

#endif
