/*!Implements a raycaster for BCC grid data.
 Author:	Steven Bergner
 Created:	Mar03
*/

#ifndef _VUVOLUMEBCCUNIMODAL3D1B1INTENSITYRAYCASTER_H_
#define _VUVOLUMEBCCUNIMODAL3D1B1INTENSITYRAYCASTER_H_

#include "../intensity.h"
#include "vuSimpleTypes.h"
#include "vuVector.h"
#include "vuMatrix.h"
#include "vuImage.h"

class vu1512113;
typedef vu1512113 vuVolumeBccUnimodal3d1BIntensityRaycaster;

/*!unoptimized raycasting 
 \todo
 make images pretty
 */
class vu1512113 : public vu151211
{
 public:
  bool refresh;
  //!Default constructor creating an empty instance.
  vu1512113();
  //!Copy constructor which does a deep copy.
  vu1512113(const vu1512113& inst);
  //!Destructor.
  virtual ~vu1512113();

  //!Assignment operator which does a deep copy.
  vu1512113& operator=(const vu1512113& rhs);

 public:
  //!Sets the camera viewing position for the render method.
  void setViewVectors(const vuVector& view,const vuVector& up,const vuVector& right);

  //!Sets the size of the rendering canvas
  void setImageSize(int sx, int sy);

  /** Returns a pointer to the current image.
      Warning: The image (an it's dimensions) may change in the next resize or
      render operation. */
  vuImage *getImage() { return &m_Image; }

  //!Initializes open gl for rendering the volume data.
  void initOpenGL(void);
  //!Implements the abstract render() method of the vuVolume base class.
  void render();

  //!Reimplements the read() method to do some extra volume data processing.
  virtual bool read();
    
  //!This method reads volume data stored using the .raw data type.
  virtual bool readRaw(void);

  //!implementation of a virtual function
  void displayFromImage();

  //!sets sampling distance (default=1.0);
  void setSamplingDistance(float sdist) {
      m_SamplingDistance = sdist;
  }
  //!returns sampling distance
  float getSamplingDistance() const { return m_SamplingDistance;}
  //!change direction of the light (default is (1,0,0))
  void setLightDir(const vuVector ldir) {
      m_LightDir = ldir;
  }
  //!get direction of the light
  const vuVector getLightDir() { return m_LightDir; }

 private:
  //!Preprocesses volume data for rendering once it's been read.
  void preprocess(void);
  bool intersectRayWithBox(vuVector Ro, vuVector Rd, vuVector *f, vuVector *s, vuVector *llc, vuVector *urc);
  void renderImage();

 private:

  float*       m_Normals;

  vuImage      m_Image;             //!< image (just an RGB byte framebuffer)
  float	       m_SamplingDistance;  //!< sampling distance (default=1.0)
  vuVector     m_LightDir;          //!< direction of the light
  vuColourRGBa m_Specular;          //!< specular colour (set to white)
};

#endif
