#ifndef _VUVOLUMEBCCUNIMODAL3D1B_H_
#define _VUVOLUMEBCCUNIMODAL3D1B_H_

#include "../3d.h"

class vu15121;
typedef vu15121 vuVolumeBccUnimodal3d1B;

//!The base class for bcc unimodal 3d 1 byte data in the vuVolume data tree.
class vu15121 : public vu1512
{
 public:
  //!Reads volume data from the data file set with setFileName().
  /*!This implements the abstract read() method from the general Volume class.
    If the read is successful, the function returns true.  If the file does
    not exist or is in an invalid format, the function returns false.  In
    this case, the error information is set for the instance.
    \return True if successful, false otherwise.
  */
  virtual bool read(void);
  //!Writes volume data to the data file set with setFileName().
  /*!This implements the abstract write() method from the general Volume class.
    \return True if successful, false otherwise.
  */
  virtual bool write(void);

  /** This will return the value stored at (x, y, z)

      If x,, y or z are out of range, then this will return 0
  */
  unsigned char getDataValue(unsigned int x, unsigned int y, unsigned int z);

  /** this will return the data value associated with the vuVector point

      This currently uses the data value stored at the nearest neighbour.

      This returns a dboule in case it is later overwritten to use interpolation to determine the value.
  */
  double getDataValue(vuVector point);

  /** This will return the the gradient at point i, j, k

     Except that
     If k % 2 == 1, then i and j will be incremented.

     and

     k be measured wider...
  */
  vuVector getGradient(unsigned int i, unsigned int j, unsigned int k);

  /** This will return the gradient of the nearest neighbour to point*/
  vuVector getGradient(vuVector point);

 protected:
  //!Asserts that the file is 3d data and reads the associated information.
  /*!This method reads in the general information for 3d data sets.
    It also asserts whether the data is indeed 3d or not.
    \return True if successful (data is bcc), false otherwise.
  */
  bool read(FILE *file);
  //!Writes the general 3d data information to the file.
  /*!\return True if successful, false otherwise.
   */
  bool write(FILE *file);
};

#endif
