#include "1B.h"
#include <stdio.h>

//----------------------------------------------------------------------------
//------------------------- public read() ------------------------------------
//----------------------------------------------------------------------------

bool vu15121::read(void)
{
    if (m_FileName.isEmpty()) return setError("No file name specified.");
    
    FILE *file = fopen(m_FileName,"rb");
    if (file != NULL)
    {
        bool success = read(file);
        fclose(file);
        return success;
    }
    else
        return setError("Could not open the specified file.");
}

//----------------------------------------------------------------------------
//------------------------- public write() -----------------------------------
//----------------------------------------------------------------------------

bool vu15121::write(void)
{
    if (m_FileName.isEmpty()) return setError("No file name specified.");
    
    FILE *file = fopen(m_FileName,"wb");
    if (file != NULL)
    {
        bool success = write(file);
        fclose(file);
        return success;
    }
    else
        return setError("Could not open the specified file.");
}

//----------------------------------------------------------------------------
//------------------------- protected read() ---------------------------------
//----------------------------------------------------------------------------

bool vu15121::read(FILE *file)
{
    int ret = 0;
    dword size = 0;
    int len = 0;

    //Read in the base data.
    bool success = vu1512::read(file);
    if (!success) return false;

    //Read in the name of the data
    char dataName[64];
    ret = fscanf(file,"SCALARS %s ",dataName);
    if (ret != 1) return setInvalidFormatError();
    //Store the name of the data
    m_DataName = dataName;

    //Read in the type of data and the colour lookup table.
    fscanf(file,"byte LOOKUP_TABLE default%n",&len);
    if ((len < 25) || (fgetc(file) != '\n')) return setInvalidFormatError();

    //Allocate memory for the volume data
    m_Data = new byte[m_DataSize];

    //Read in the volume data according to the format of the file
    if (m_Binary)
        size = fread(m_Data,sizeof(byte),m_DataSize,file);
    else
    {
        ret = 1;
        dword i = 0;
        while ((ret > 0) && (i < m_DataSize))
            ret = fscanf(file," %c",&m_Data[i++]);
        size = i;
    }
    
    //Make sure that the right amount of data was read in
    if (size != m_DataSize) return setInvalidFormatError();

    return true;
}

//----------------------------------------------------------------------------
//------------------------- protected write() --------------------------------
//----------------------------------------------------------------------------

bool vu15121::write(FILE *file)
{
    int ret;
    dword size = 0;

    m_Binary = true;

    bool success = vu1512::write(file);
    if (!success) return false;
    
    fprintf(file,"SCALARS ");

    //Write the name of the data
    if (!m_DataName.isEmpty())
        fprintf(file,"%s ",m_DataName.c_str());
    else
        fprintf(file,"data ");

    fprintf(file,"byte\nLOOKUP_TABLE default\n");

    //Write the volume data according to it's format
    if (m_Binary)
        size = fwrite(m_Data,sizeof(byte),m_DataSize,file);
    else
    {
        ret = 1;
        dword i = 0;
        while ((ret > 0) && (i < m_DataSize))
            ret = fprintf(file," %d",m_Data[i++]);
        size = i;
    }
    
    if (size == m_DataSize)
        return true;
    else
        return setWriteError();
}

unsigned char vu15121::getDataValue(unsigned int x, unsigned int y, unsigned int z)
{
  if ( (x<0) || (x>=m_Dim1Size) || (y<0) || (y>=m_Dim2Size) || (z<0) || (z>=m_Dim3Size) )
    return 0;
  else
    return m_Data[x+y*m_Dim1Size+z*m_Dim1Size*m_Dim2Size];
}

double vu15121::getDataValue(vuVector point)
{
  //
  //nearest neighbor
  //

  int x1, y1, z1, x2, y2, z2;

  // nearest neighbor in primary grid 
  x1 =   int(point[0]/T + 0.5);
  y1 =   int(point[1]/T + 0.5);
  z1 = 2*int(point[2]/T + 0.5);

  // nearest neighbor in secondary grid 
  x2 =   int(point[0]/T);
  y2 =   int(point[1]/T);
  z2 = 2*int(point[2]/T) + 1;

  double d1, d2;

  d1 = ((point[0] - float(x1)*T    )*(point[0] - float(x1)*T    ) +
	(point[1] - float(y1)*T    )*(point[1] - float(y1)*T    ) +
	(point[2] - float(z1)*T*0.5)*(point[2] - float(z1)*T*0.5));
  //SB011027: BUG fixed. (?)
  d2 = ((point[0] - (float(x2) + 0.5)*T    )*(point[0] - (float(x2) + 0.5)*T    ) +
	(point[1] - (float(y2) + 0.5)*T    )*(point[1] - (float(y2) + 0.5)*T    ) +
	(point[2] - (float(z2) + 0.5)*T*0.5)*(point[2] - (float(z2) + 0.5)*T*0.5));

  if (d1 < d2)
    return getDataValue(x1, y1, z1);
  else
    return getDataValue(x2, y2, z2);
}

vuVector vu15121::getGradient(unsigned int i, unsigned int j, unsigned int k)
{
  i += (k % 2);
  j += (k % 2);

  vuVector t(0.5*(double(getDataValue(i+1, j  , k  ) - getDataValue(i-1, j  , k  ))),
	     0.5*(double(getDataValue(i  , j+1, k  ) - getDataValue(i  , j-1, k  ))),
	     0.5*(double(getDataValue(i  , j  , k+2) - getDataValue(i  , j  , k-2))));

  return t;
}

vuVector vu15121::getGradient(vuVector point)
{
  //
  //nearest neighbor
  //

  int x1, y1, z1, x2, y2, z2;

  // nearest neighbor in primary grid 
  x1 =   int(point[0]/T + 0.5);
  y1 =   int(point[1]/T + 0.5);
  z1 = 2*int(point[2]/T + 0.5);

  // nearest neighbor in secondary grid 
  x2 =   int(point[0]/T);
  y2 =   int(point[1]/T);
  z2 = 2*int(point[2]/T) + 1;

  double d1, d2;

  d1 = ((point[0] - float(x1)*T    )*(point[0] - float(x1)*T    ) +
	(point[1] - float(y1)*T    )*(point[1] - float(y1)*T    ) +
	(point[2] - float(z1)*T*0.5)*(point[2] - float(z1)*T*0.5));

  d2 = ((point[0] - (float(x2) + 0.5)*T    )*(point[0] - (float(x2) + 0.5)*T    ) +
	(point[1] - (float(y2) + 0.5)*T    )*(point[1] - (float(y2) + 0.5)*T    ) +
	(point[2] - (float(z2) + 0.5)*T*0.5)*(point[2] - (float(z2) + 0.5)*T*0.5));

  if (d1 < d2)
    return getGradient(x1, y1, z1);
  else
    return getGradient(x2, y2, z2);
}
