#include <iostream>
#include <fstream>
#include <unistd.h>
#include <errno.h>
#include <stdlib.h>
#include "vuFileHelper.h"
#include "Volume/Regular/Unimodal/3d/1B/1B.h"
#include "Volume/Regular/Unimodal/3d/2B/2B.h"
#include "vuHistogram.h"
#include "vuConvert.h"

using namespace std;

void usage(const char* exe);
bool readnumber(const char* str, int& number);

int main(int argc, char ** argv)
{
    if(argc != 7) {
	usage(argv[0]);
	return -1;
    }

    vuString fileName = argv[1];
    vuString fileType = vuFileHelper::getFileType(fileName);
    if (fileType.isEmpty()) {
	cout << "Error: Wrong filetype." << endl;
	return -1;
    }

    vuString outfileName = argv[2];

    int inter[4];
    int i;
    for(i=0; i<4; i++)
    {
	if(!readnumber(argv[i+3], inter[i])) {
	    usage(argv[0]);
	    return false;
	}
    }
    cout << "loading" << endl;
    vu11122 volume;
    volume.setFileName(fileName);
    if(!volume.read()) {
	cout << "Error: Could not load file " << fileName << "." << endl;
	return -1;
    }

    vuMap map;
    map.createRamp(inter[0], inter[1], inter[2], inter[3]);
    volume.remap(map);

    vu11121 bvol;
    vuConvert::convert(bvol, volume);
    bvol.setFileName(outfileName);
    cout << "writing file " << bvol.getFileName() << endl;
    bvol.write();

    cout << "done." << endl;
    return 0;
}

void usage(const char* exe)
{
    const char *file = strrchr(exe,'/');
    if(!file) 
    {
	file = strrchr(exe,'\\');
	if(file) file++;
	else file = exe;
    } else file++;

    cout << "usage:  " << file << " inputfile outputfile "
	 << "start startval end endval" << endl << endl;
    cout << "inputfile      name of vud file (data type word) including extension"<<endl;
    cout << "outputfile     name of output vud file (data type byte)"<<endl;
    cout << "start          start of intensity range to map" << endl;
    cout << "startval       start value of range to map to" << endl;
    cout << "end            end of intensity range to map" << endl;
    cout << "endval         end value of range to map to" << endl;
}

bool readnumber(const char* str, int& number)
{
    char *endp;
    errno = 0;
    number = strtol(str,&endp,10);
    if(errno || 
       endp != str+strlen(str)) return false;
    return true;
}

