#include <iostream>
#include <fstream>
#include <unistd.h>
#include <errno.h>
#include <stdlib.h>
#include "vuFileHelper.h"
#include "Volume/Regular/Unimodal/3d/1B/1B.h"
#include "vuHistogram.h"

using namespace std;

void usage(const char* exe);
bool readnumber(const char* str, int& number);

int main(int argc, char ** argv)
{
    if(argc != 6) {
	usage(argv[0]);
	return -1;
    }

    vuString fileName = argv[1];
    vuString fileType = vuFileHelper::getFileType(fileName);
    if (fileType.isEmpty()) {
	cout << "Error: Wrong filetype." << endl;
	return -1;
    }

    vuString outfileName = argv[2];

    int scale[3];
    int i;
    for(i=0; i<3; i++)
    {
	if(!readnumber(argv[i+3], scale[i])) {
	    usage(argv[0]);
	    return false;
	}
    }
    cout << "loading" << endl;
    vu11121 volume;
    volume.setFileName(fileName);
    if(!volume.read()) {
	cout << "Error: Could not load file " << fileName << "." << endl;
	return -1;
    }
    vu11121 scalevol;
    scalevol.scaleFrom(volume, scale[0], scale[1], scale[2]);
    scalevol.setFileName(outfileName);
    scalevol.write();

    cout << "done." << endl;
    return 0;
}

void usage(const char* exe)
{
    const char *file = strrchr(exe,'/');
    if(!file) 
    {
	file = strrchr(exe,'\\');
	if(file) file++;
	else file = exe;
    } else file++;

    cout << "usage:  " << file << " inputfile outputfile Xscale Yscale Zscale" 
	 << endl << endl;
    cout << "inputfile      name of vud file including extension"<<endl;
    cout << "outputfile     name of histogram file to ouput"<<endl;
    cout << "Xscale	    new x dimension" << endl;
    cout << "Yscale         new y dimension" << endl;
    cout << "Zscale         new z dimension" << endl;
}

bool readnumber(const char* str, int& number)
{
    char *endp;
    errno = 0;
    number = strtol(str,&endp,10);
    if(errno || 
       endp != str+strlen(str)) return false;
    return true;
}

