#include <iostream>
#include <fstream>
#include <unistd.h>
#include <errno.h>
#include <stdlib.h>
#include "vuFileHelper.h"
#include "Volume/Regular/Unimodal/3d/2B/2B.h"
#include "Volume/Regular/Unimodal/3d/1B/1B.h"
#include "vuHistogram.h"

using namespace std;

void usage(const char* exe);
bool readnumber(const char* str, int& number);

int main(int argc, char ** argv)
{
    if(argc != 3) {
	usage(argv[0]);
	return -1;
    }

    vuString outfileName = argv[2];
    vuString fileName = argv[1];
    vuString fileType = vuFileHelper::getFileType(fileName);
    vu1112 *volume = NULL;
    if (fileType.isEmpty()) {
	cout << "Error: Wrong filetype." << endl;
	return -1;
    } else if(fileType == "11121") volume = new vu11121;
    else if(fileType == "11122") volume = new vu11122;
    else {
	cout << "Error: Unsupported volume type " << fileType << endl;
	return -1;
    }
    

    cout << "loading" << endl;
    volume->setFileName(fileName);
    if(!((vu1*)volume)->read()) {
	cout << "Error: Could not load file " << fileName << "." << endl;
	return -1;
    }
    cout << "calculating histogram" << endl;
    vuHistogram hist(vuHistogram::TYPE_INTENSITY);
    volume->createHistogram(hist);
    ofstream hf(outfileName);
    hf << hist;
    hf.close();
    cout << "done." << endl;
    return 0;
}

void usage(const char* exe)
{
    const char *file = strrchr(exe,'/');
    if(!file) 
    {
	file = strrchr(exe,'\\');
	if(file) file++;
	else file = exe;
    } else file++;

    cout << "usage:  " << file << " inputfile outputfile " 
	 << endl << endl;
    cout << "inputfile      name of vud file including extension"<<endl;
    cout << "outputfile     name of histogram file to ouput"<<endl;
}

bool readnumber(const char* str, int& number)
{
    char *endp;
    errno = 0;
    number = strtol(str,&endp,10);
    if(errno || 
       endp != str+strlen(str)) return false;
    return true;
}

