#include <iostream>
#include <fstream>
#include <unistd.h>
#include <errno.h>
#include <stdlib.h>
#include "vuFileHelper.h"
#include "Volume/Regular/Unimodal/3d/1B/1B.h"
//#include "Volume/Regular/Unimodal/3d/2B/2B.h"
#include "vuHistogram.h"

using namespace std;

void usage(const char* exe);
bool readnumber(const char* str, int& number);

int main(int argc, char ** argv)
{
    if(argc != 9) {
	usage(argv[0]);
	return -1;
    }

    vuString fileName = argv[1];
    vuString fileType = vuFileHelper::getFileType(fileName);
    if (fileType.isEmpty()) {
	cout << "Error: Wrong filetype." << endl;
	return -1;
    }

    vuString outfileName = argv[2];

    word cube[6];
    int i;
    for(i=0; i<6; i++)
    {
	int number;
	if(!readnumber(argv[i+3], number)) {
	    usage(argv[0]);
	    return false;
	}
	cube[i] = (word)number;
    }
    cout << "loading" << endl;
    vu11121 volume;
    volume.setFileName(fileName);
    if(!volume.read()) {
	cout << "Error: Could not load file " << fileName << "." << endl;
	return -1;
    }
    vu11121 cropvol;
    cropvol.cropFrom(volume, cube);
    cropvol.setFileName(outfileName);
    cout << "writing file " << cropvol.getFileName() << endl;
    cropvol.write();

    cout << "done." << endl;
    return 0;
}

void usage(const char* exe)
{
    const char *file = strrchr(exe,'/');
    if(!file) 
    {
	file = strrchr(exe,'\\');
	if(file) file++;
	else file = exe;
    } else file++;

    cout << "usage:  " << file << " inputfile outputfile x0 x1 y0 y1 z0 z1" 
	 << endl << endl;
    cout << "inputfile      name of vud file including extension"<<endl;
    cout << "outputfile     name of histogram file to ouput"<<endl;
    cout << "six numbers    start and end for each dimension" << endl;
}

bool readnumber(const char* str, int& number)
{
    char *endp;
    errno = 0;
    number = strtol(str,&endp,10);
    if(errno || 
       endp != str+strlen(str)) return false;
    return true;
}

