/********************************************************************************
 *                                                                              *
 *   Removes the CR characters from an arbitrary textfile (by Martin Spindler)  *
 *   Usage: crlf2lf file1 file2 ...                                             *
 *                                                                              *
 ********************************************************************************/

#include <string>
#include <iostream>
#include <fstream>

using namespace std;

#define LF_CHAR 10
#define CR_CHAR 13

void crlf2lf(char *fileName, bool doVerbose = true)
{
  ifstream  fin;
  unsigned  hits = 0;

  fin.open(fileName);
  if (fin.is_open()) {
    ofstream  fout;
    streambuf *pIn;
    char*     buffer = new char[1000000];
    char*     ptr    = buffer;
    int       len    = 0;

    pIn = fin.rdbuf();

    while (pIn->sgetc() != EOF) {
      char chr = pIn->sbumpc();
      if (chr != CR_CHAR) {
	*(ptr++) = chr;
	len++;
      }
      else
	hits++;
    }
    fin.close();

    if (hits) {
      ptr = buffer;
      fout.open(fileName);
      for (;len>0;len--) fout << *(ptr++);
      fout.close();
    }
    delete [] buffer;
  }
  else {
    cerr << "Warning: Could not find file " << fileName << endl;
  }
  if (doVerbose && hits) {
    clog << fileName << ": "<< hits << " CRs removed"<< endl;
  }
}

int main(int argc, char** argv)
{
  if (argc > 1) {
    for (int i=1; i<argc; i++) crlf2lf(argv[i]);
  }
  else {
    cerr << "Removes the CR chars from an arbitrary file" << endl;
    cerr << "Usage: crlf2cr file1 ..." << endl;
  }
  return 0;
}
