#include <iostream>
#include <fstream>
#include <unistd.h>
#include <errno.h>
#include <stdlib.h>
#include "Volume/Regular/Unimodal/3d/2B/2B.h"

using namespace std;

void usage(const char* exe);
bool readnumber(const char* str, int& number);

int main(int argc, char ** argv)
{
    if(argc < 5) {
	usage(argv[0]);
	return -1;
    }

    vu11122 volume;
    int startID, endID, incID = 1;
    if(!readnumber(argv[3], startID)) { usage(argv[0]); return false; }
    if(!readnumber(argv[4], endID)) { usage(argv[0]); return false; }
    if (argc == 6) 
	if(!readnumber(argv[5], incID)) { usage(argv[0]); return false; }

    cout << "reading slices with mask " << argv[1] << " from " << startID 
	 << " to " << endID << endl;
    if(readFreZ(volume, argv[1], startID, endID, incID))
    {
	volume.setFileName(argv[2]);
 	volume.write();
    } else cout << "Error: Could not load file." << endl;

    cout << "done." << endl;
    return 0;
}

void usage(const char* exe)
{
    const char *file = strrchr(exe,'/');
    if(!file) 
    {
	file = strrchr(exe,'\\');
	if(file) file++;
	else file = exe;
    } else file++;

    cout << "usage:  " << file << " inputmask outputfile startID " 
	 << "endID [incrementID]" << endl << endl;
    cout << "inputmask    format string with ID, e.g., \"c_vm%i.fre.Z\" "<<endl;
    cout << "outputfile   name of vud file including extension"<<endl;
    cout << "startID      file ID number of first slice" << endl;
    cout << "endID        file ID numer of last slice, has to be greater than "
	 << "startID" << endl;
    cout << "incrementID  stepping if only every nth slice should be read. "
	 << "(default is 1)" << endl;
}

bool readnumber(const char* str, int& number)
{
    char *endp;
    errno = 0;
    number = strtol(str,&endp,10);
    if(errno || 
       endp != str+strlen(str)) return false;
    return true;
}

