/* creates a character array from a binary file
   This can be used to include images into the executable.
   example:
   on command line: bin2h bulb.png bulb.h bulbimg
   in vuLightDial.cpp:
   #include "bulb.h"
   #define HEADERIMG(varname) varname, varname ## _size
   ... in constructor:
   wxMemoryInputStream mims(HEADERIMG(bulbimg));
   wxImage image(mims);
   m_BulbImg = new wxBitmap( image.ConvertToBitmap() );
   ... in OnPaint:
   int xofs = m_BulbImg->GetWidth()/2;
   int yofs = m_BulbImg->GetHeight()/2;
   dc.DrawBitmap( *m_BulbImg, m_LPos[l].x-xofs,m_LPos[l].y-yofs, true );
 */

#include <iostream.h>
#include <fstream.h>
#include <unistd.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>

#include "vuString.h"

using namespace std;

void usage(const char* exe);
bool readnumber(const char* str, int& number);

int main(int argc, char ** argv)
{
    if(argc != 4) {
	usage(argv[0]);
	return -1;
    }

    vuString fileName = argv[1];
    vuString outfileName = argv[2];
    vuString varName = argv[3];

    ifstream is(fileName, ios::binary);
    if(!is) {
      cout << "error opening " << fileName << " for reading." << endl;
      return -1;
    }

    ofstream os(outfileName);
    if(!os) {
      cout << "error opening " << outfileName << " for writing." << endl;
      return -1;
    }

    is.seekg(0, ios::end);
    int size = is.tellg();
    is.seekg(0, ios::beg);
    if (size <= 0) {
      cout << "input file " << fileName << " has zero size." << endl;
      return -1;
    }
    cout << "reading " << size << " bytes from " << fileName << " ..." << endl;
    
    os << "//Header for file " << fileName << " written in variable " 
       << varName << endl << endl;
    os << "int " << varName << "_size = " << size << ";" << endl;
    os << "char " << varName << "["<<size<<"] = { " << endl;

    char buffer[1024];
    is.read(buffer, 1024);
    int blen = is.gcount();
    int rest = size;
    os.flags(ios::showbase|ios::hex);
    os << (unsigned int)((unsigned char)buffer[0]);
    rest--;
    int pos = 1;
    while(rest) {
      if(pos == blen) {
	is.read(buffer, 1024);
	blen = is.gcount();
	pos = 0;
      }
      os << ", ";
      if(!(pos%8)) os << endl;
      os << hex << (unsigned int)((unsigned char)buffer[pos]);
      pos++;
      rest--;
    }
    os << "};" << endl;
    os.close();
    cout << "done." << endl;
    return 0;
}

void usage(const char* exe)
{
    const char *file = strrchr(exe,'/');
    if(!file) 
    {
	file = strrchr(exe,'\\');
	if(file) file++;
	else file = exe;
    } else file++;

    cout << "usage:  " << file << " inputfile outputfile.h varname" << endl << endl;
    cout << "Creates a header with character array and size information from binary file." << endl;
    cout << "inputfile      name of input file (some binary file, eg. png)"<< endl;
    cout << "outputfile     name of output .h file"<<endl;
    cout << "varname        name of char array in header"<<endl;
}
