/* provides stand-alone interface to the spectral palette designer */
#include "wxUIElements/vuSpecPalette.h"
#include <wx/frame.h>
#include <iostream>
using namespace std;

/** \file
 *
 * This is the main program of the stand-alone spectral palette interface.
 */

//----------------------------------------------------------------------------
//------------------------- The wxApp application class ----------------------
//----------------------------------------------------------------------------

// Define a new application type
class SPaled : public wxApp
{
public:
    //! The initialization/starting function of the program.
    /*! It passes on the initialization to the vuMainWindow class */
       bool OnInit();

private:
    //! The vuMainWindow instance for the program.
    wxFrame *m_Main;
};

//----------------------------------------------------------------------------
//------------------------- public: bool OnInit() ----------------------------
//----------------------------------------------------------------------------

bool SPaled::OnInit()
{
    SPalette spal;
    vuSpecPalette spalDlg(m_Main, spal);
    SetTopWindow(&spalDlg);
    if(argc > 1) {
	cout << "loading palette "<<argv[1]<<" ... ";
	if(!spal.load(argv[1])) {
	    cout << "error loading file." << endl;
	    return false;
	} else {
	    cout << "done."<<endl;
	    spalDlg.FitAllDesignColours();
	}
    }
    if(spalDlg.ShowModal() == wxID_OK) {
      return false;	// false to make the terminate the application
    } else return false;
};
//----------------------------------------------------------------------------
//------------------------- Main program implementation ----------------------
//----------------------------------------------------------------------------

    //This wxWindows macro implements the main function of the program.
    //See the wxWindows documentation for more information.

IMPLEMENT_APP(SPaled)
