#include "vuTFunc/vuTFDesign.h"
#include "Volume/Regular/Unimodal/3d/1B/Intensity/Raycast/Raycast.h"
#include "vuLightfield/vuSphericView.h"
#include "vuMisc/vuUDSphere.h"


class Scanner
{
 public:
  Scanner(const char *fileName, dword width, dword height, dword views);
  ~Scanner();

  void loadTFuncFromFile(const char *fileName);

  void lazyCalculateAndDisplay(const char *fileName);
  void lazyCalculateAndLog(const char *fileName);

 private:
  vuUDSphere *m_Sphere ;    // Uniform Distribution in Sphere
  vu1112113  *m_Raycast;    // raycaster
  vuTFDesign m_TransFunct;  // Transfer function
  bool       m_isComputed;  // is lightfield already computed
  dword      m_Width;       // width of each view
  dword      m_Height;      // height of each view
  dword      m_Views;       // number of views

  void _initTransferFunction();
  void _renderView(dword i, vuSphericView3B *view, bool verbose=true);
  word _numberOfDigits(word number);
  void _lazyCalculate(const char *fileName, bool display);
  void _calcViewVectors(vuVector& lookAt, vuVector& up, vuVector& right);
};
