#include "vuTFunc/vuTFDesign.h"
#include "Volume/Fourier/Unimodal/3d/StandardFVR/StandardFVR.h"
#include "vuLightfield/vuSphericView.h"
#include "vuMisc/vuUDSphere.h"

class FourierSlicer_
{
 public:
  virtual void  lazyCalculateAndDisplay(const char *fileName) = 0;
  virtual void  lazyCalculateAndLog(const char *fileName)     = 0;
  virtual dword getImageWidth()  = 0;
  virtual dword getImageHeight() = 0;
};

template <int SIZE>
class FourierSlicer : public FourierSlicer_
{
 public:

  // file must be an unimodal fourier file (*.vuf), but might have S channels 
  FourierSlicer(vuString fileName, dword numOfviews,
		float scale, float bias, vuString filterName,
		vuString timingFileName);
  virtual ~FourierSlicer();

  void lazyCalculateAndDisplay(const char *fileName);
  void lazyCalculateAndLog(const char *fileName);

  dword getImageWidth();
  dword getImageHeight();

 private:
  vuUDSphere     *m_Sphere ;        // Uniform Distribution in Sphere
  vu1712_1<SIZE> *m_Fourier;        // standard fourier volume renderer
  vuTFDesign      m_TransFunct;     // Transfer function
  bool            m_isComputed;     // is lightfield already computed
  dword           m_Width;          // width of each view
  dword           m_Height;         // height of each view
  dword           m_NumOfViews;     // number of views
  dword           m_ExternalWidth;  // image width for the lightfield
  dword           m_ExternalHeight; // image height for the lightfield
  ostream        *m_TimingStream;

  void _initTransferFunction();
  void _renderView(dword i, vuSphericView<SIZE,byte> *view, bool verbose=true);
  word _numberOfDigits(word number);
  void _lazyCalculate(const char *fileName, bool display);
};

template FourierSlicer<1>;
template FourierSlicer<2>;
template FourierSlicer<3>;
