#include <stdio.h>
#include "Volume/Regular/Unimodal/3d/1B/Intensity/SimpleFVR/vuSimpleFVR.h"
#include "vuMisc/vuCommandLineTool.h"

/* 
   Usage: vuf2vud OPTIONS input.vuf output.vud

   OPTIONS:
*/


vuString g_ErrorMsg;
vuString g_OutputFile;
vuString g_InputFile;
float    g_Scale     = 1.0f;

void doIt(void) {
  cout << "scale   = " << g_Scale   << endl;
  vu1112119::convertVUF2VUD(g_InputFile, g_OutputFile, g_Scale);
}

vuString _helpString(vuCommandLineTool &tool)
{
  vuString str;


  str += "Creates a spatial volume from a fourier volume of type '*.vuf'.\n\n";
  str += "Usage: ";
  str += tool.toolName();
  str += " [additional_options] inputFile outputFile\n";
  str += "\nadditional_options:\n";
  str += "  --scale=fff    image scaling  (1.0),         e.g. --scale=25.5\n";
  str += "  --help         prints this help text\n";
  str += "\ninputFile:\n";
  str += "  a frequency volume file,                     e.g. engine.vuf\n";
  str += "\noutputFile:\n";
  str += "  a regular 3D vuVolume data file,             e.g. engine.vud\n";

  return str;
}

bool _parseParameters(int argc, const char **argv)
{
  bool isOk = true;
  vuCommandLineTool tool(argc, argv);

  if (tool.hasParameter("--help")) {
    g_ErrorMsg += _helpString(tool);
    return false;
  }

  if (tool.hasParameter("--scale"))
      g_Scale = tool.floatForParameter  ("--scale");

  g_ErrorMsg += "Following error(s) occured:\n";

  bool isValid;
  word fileCount = tool.numberOfNonParameters(isValid);

  if (fileCount == 0) {
    g_ErrorMsg += "  - Neither an input nor an output file is specified.\n";
    isOk = false;
  }
  else if (fileCount == 1)  {
    g_ErrorMsg += "  - No output file specified.\n";
    isOk = false;
  }
  else if (fileCount == 2 && isValid)  {
    g_InputFile  = tool.getArgument(argc-2);
    g_OutputFile = tool.getArgument(argc-1);
    if (!tool.fileExists(g_InputFile)) {
      g_ErrorMsg += "  - InputFile does not exist ('";
      g_ErrorMsg += g_InputFile + "').\n";
      isOk = false;
    }
    if (g_OutputFile.isEmpty()) {
      g_ErrorMsg += "  - No output file specified.\n";
      isOk = false;
    }
  }
  else if (fileCount > 2)  {
    g_ErrorMsg += "  - More than one input and one output file specified.\n";
    isOk = false;
  }
  else {
    g_ErrorMsg += "  - The input and output file are expected to be at the ";
    g_ErrorMsg += " end of the line.\n";
    isOk = false;
  }

  g_ErrorMsg += "\nType '" + tool.toolName() + " --help' for more information!\n";

  if (isOk) g_ErrorMsg = "";

  return isOk;
}

int main(int argc, const char **argv)
{
  if (!_parseParameters(argc, argv)) {
    cerr << g_ErrorMsg << endl;
    exit(0);
  }

  doIt();

  return 0;
}
