/*	Written by Christopher Steinbach
	March 2002

	written to add a timer that could fast forward and rewind and bounce
	and loop easily to the key framer.

	uses the wxStopwatch
*/

#ifndef vuStopWatch_h__
#define vuStopWatch_h__

#include <iostream.h>

/**  	Stop watch class for the vuVolume project.  This was written so that I

     	would have a stop watch that I could tell to fast forward and rewind easily
	for the Key Frame animator.  (that way I could remove some of the code from
	that giant object and have something that might be useful later on).

	This work's with time values in milliseconds, and is based on two
	wxStopWatches (though we may want to replace these with a more accurate
	vuHWTimers later on if they ecome more accurate in Linux).

	If this watch is rewinding, then successive calls to the watch will return
	smaller and smaller values, if it's fast forwarding, then larger and larger
	faster than normal speed... etc.
*/
class vuStopWatch

{
	public:	// constructors and destructors.

		/** Default constructor,

		    This will set the start the StopWatch at time time_in_ms in milliseconds. */
		vuStopWatch (int time_in_ms = 0);

		/** destructor */
		virtual ~vuStopWatch ();

	public:	// member functions - start and stop functions.

		/** This function will initialize the time of the stop watch
		    to time_in_ms and will start the watch (as if it started at time "time_in_ms").

		    Note that the time_in_ms is the value in milliseconds of the time that it should
		    start at.*/
		void Start (int time_in_ms = 0);

		/** This function will return the current time that this watch is at.

		    This time will be returned in milliseconds.*/
		int Time ();

		/** This function will pause the watch so that until the watch is resumed, it's
		    time will not be changed. */
		void Pause ();

		/** This function will resume the watch so that if the watch is paused, it will
		    be unpaused. */
		void Resume ();

		/** This returns the total time that the stop watch has been running since the
		    last call to the function, Start (); */
		int TotalTime ();

	public:	// member functions, state controlling functions.

		/** This will set the watch to be running in reverse if isit is true, and forward
		    otherwise. */
		void setIsReversing (bool isit);

		/** This will start the watch to be rewinding if isit is true, and not rewinding otherwise.*/
		void setIsRewinding (bool isit);

		/** This will start the watch to be fast forwarding if isit is true, and not fast
		    forwarding otherwise. */
		void setIsFastForwarding (bool isit);

		/** This will start the watch to be looping if isit is true and not looping otherwise.

		    When a watch is looping, if the time is greater than the maximum time, the time will be
		    reduced to zero (if it is moving in a forward direction).

		    If it is not moving in a forward direction, when the time is less than zero, it will be
		    set to be the maximum time. */
		void setIsLooping (bool isit);

		/** This will start the watch to be bouncing if isit is true and not bouncing otherwise.

		    When a watch is bouncing, if the time is greater than the maximum time, the time will
		    be set to the maximum time and the direction will be reversed.

		    If the time is less than 0, then the time will be set to zero and the direction will
		    be changed to the forward direction. */
		void setIsBouncing (bool isit);

	public:	// member functions, get the current state of the watch.

		/** This will return true if the watch is reversing, false otherwise. */
		bool IsReversing ();

		/** This will return true if the watch is rewinding, false otherwise. */
		bool IsRewinding ();

		/** This will return true if the watch is fast forwarding, false otherwise. */
		bool IsFastForwarding ();

		/** This will return true if the watch is looping, false otherwise. */
		bool IsLooping ();

		/** This will return true if the watch is bouncing, and false otherwise. */
		bool IsBouncing ();

	public:	// member functions, state setters.

		/** This will set the fast speeds to be mul * normal rate.

		    ie, if mul = 2.0, then the watch will gain one second for every second that it
		    is running. */
		void setFastSpeed (float mul);

		/** This will return the current value of the fast speed of this watch. */
		float getFastSpeed ();

		/** This will set the maximum tim that this watch should reach.

		   max_time_in_ms is in milliseconds.*/
		void setMaxTime (int maxtime_in_ms);

		/** This will return the value of the maximum time that this watch can reach,
		    in milliseconds. */
		int getMaxTime ();

	private:	// member data, stopwatches.

//		wxStopWatch m_timer_1;	/**< This is the main timer, it will keep track of the time
//						that the watch should be outpouting (but this time may
//						need to be modified if the watch is reversing, rewinding
//						or fast forwarding, by a multiple of the second watch. */
//		wxStopWatch m_timer_2;	/**< This is the secondary timer.  It will be reset on every call
//						to Time (), and will be used to work out how the first
//						watch and the output time should be changed. */
//		wxStopWatch m_timer_3;	/**< This is to keep track of the total time since the last
//						call to Start. */

		void * m_timer_1;	/**< This is the main timer, it will keep track of the time
						that the watch should be outpouting (but this time may
						need to be modified if the watch is reversing, rewinding
						or fast forwarding, by a multiple of the second watch. */
		void * m_timer_2;	/**< This is the secondary timer.  It will be reset on every call
						to Time (), and will be used to work out how the first
						watch and the output time should be changed. */
		void * m_timer_3;	/**< This is to keep track of the total time since the last
						call to Start. */
	private:	// member data, state information

		bool mb_reversing;	//!< This is true if the timer is reversing,false otherwise.

		bool mb_fastforwarding;	//!< This is true if the timer is fast forwarding, false otherwise.
		bool mb_rewinding;	//!< This is true if the timer is rewinding, false otherwise.

		bool mb_looping;	//!< This is true if the timer is looping, false otherwise.
		bool mb_bouncing;	//!< This is true if the timer is bouncing, false otherwise.

	private:	// member data, statse information.

		int m_maxtime;		//!< This is the maximum time that the timer can reach, in milliseconds
		float m_fastspeed;	/**< This is the speed multip[lier that will be applied to the time
						when it is fastforwarding or rewinding. */
};

#endif



