#ifndef SPECTRAL_OBJECTIVE_FUNCTION_HH
#define SPECTRAL_OBJECTIVE_FUNCTION_HH

#include "Coool/ObjFcn.hh"
#include "Coool/Model.hh"
#include "Coool/Matrix.hh"

class SpectralObjFcn : public ObjectiveFunction {
  private:
    const Matrix<double>	*coeff;
    Vector<double>	rhs;
    double		offset;

  protected:
    ///
    double realPerformance(const Model<double>& );
    ///
    double realPerformance(const Model<long>& );

    ///
    int mySize() const { return nparam;}

  public:
    ///
    SpectralObjFcn(const Matrix<double>* A, const Vector<double>& v, const double ofs = 0.0f)
	: ObjectiveFunction(((Matrix<double>*)A)->numOfRows()), rhs(v), offset(ofs)
	{
	    nparam = A->numOfRows();
	    //coeff = new DensMatrix<double>(A.numOfRows(),A.numOfCols());
	    coeff = A;
	};
    
    ~SpectralObjFcn()
	{	
	    delete coeff;
	}
	  

    /** we don't compute the gradients -> linesearch will use
	finite differences instead */
    //Vector<double>*	getGradient(const Model<double>&);
    ///
    //Vector<double>*	getGradient(const Model<long>&);
    ///
    const char* className() const { 
	static char classname[] = "Spectral";
	return classname; 
    }
};

double SpectralObjFcn::realPerformance(const Model<double>& m)
{
    Vector<double> v(m.modParam()), u(rhs.size()); //SB!!
    
    u = ((Matrix<double>*)(coeff))->adotx(v) - rhs;

    return (u*u) + offset;
}

double SpectralObjFcn::realPerformance(const Model<long>& m)
{
    Model<double> temp(m.modSize());
    temp = m;

    return realPerformance(temp);
}

#endif
