#include <iostream>
#include <stdio.h>

#include "SOptimizer.h"

#include "Coool/C++.hh"
#include "Coool/ObjFcns.hh"
#include "Coool/Optim.hh"
#include "SpecObj.hh"

#include "LinAlg/svd.h"

//#define SOPT_TAU	0.0f
#define SOPT_TAU	0.0000001f

SOptimizer::SOptimizer()
{
    m_Verbose		= 0;
    m_ItMax		= 100;
    m_ItMaxLine		= 15;
    m_Tol		= 0.001;
    m_NIter		= 0;
    m_Residue		= 0;
    m_GradStep		= 0.1;
}

SOptimizer::~SOptimizer()
{
}

/** searches for a vector x minmizing |Mx - y| while
    satisfying the constraints (upper and lower bounds).
    \param M matrix
    \param y vector to minimize for
    \param ub vector for upper bounds per component
    \param lb vector for lower bounds
*/
SVector SOptimizer::minimize(const SMatrix& M, const SVector& y,
			     const SVector& lb, const SVector& ub)
{
    SVector step(M.getNCols(), m_GradStep);
    return minimize(M, y, lb, ub, step);
}

SVector SOptimizer::minimize(const SMatrix& M, const SVector& y,
			     const SVector& lb, const SVector& ub, 
			     const SVector& gradstep)
{
    using namespace coool;
    
    int modelsize	= M.getNCols();

    DensMatrix<double> matA(M);
    Vector<double> h(y);

    // construct the model space with UPPER and LOWER bound
    Vector<double> v(modelsize), upBound(ub),lowBound(lb);
    //v = 1.0f;
    v = minimize(M,y);	// use unconstrained solution as initial guess
    v.constrain(lb,ub);
    
    Vector<double> step((SVector&)gradstep);
    //step = 0.1;				// for numerical gradient
    
    // constructing the initial model without UPPER and LOWER bound
    //Model<double> m(v);
    // constructing the initial model with UPPER and LOWER bound
    Model<double> m(upBound,lowBound,v);

    // Read the Right hand side
    //Vector<double>& rhs = h;
    
    //Constrcut optimization objects
    //LinearForward* lop = new LinearForward(&matA);

    //QuadraticObjFcn* qobj = new QuadraticObjFcn(modelsize, &matA, &h, 0.0f);
    SpectralObjFcn* obj = new SpectralObjFcn(&matA, h);
    
    /****IF USING ART, UNCOMMENT THE FOLLOWING LINE**********/
    // QuadraticOptima* opt = new ART(modelsize, lop, rhs, itMax, tol, verbose);
    /****IF USING SIRT, UNCOMMENT THE FOLLOWING LINE**********/
    // QuadraticOptima* opt = new SIRT(modelsize, lop, rhs, itMax, tol, verbose);

    /****IF USING IRLS, UNCOMMENT THE FOLLOWING LINE**********/
    //QuadraticOptima* opt = new IterativeReweightedLS( modelsize, lop, &rhs, 
    //						      1, 2,itMax, tol, tol, verbose);

    /****IF USING CGLS, UNCOMMENT THE FOLLOWING LINE**********/
    //QuadraticOptima* opt = new LSConjugateGradient(modelsize, lop, &rhs,
    //						   itMax, tol, verbose);

    /****IF USING CG, UNCOMMENT THE FOLLOWING LINE**********/
    CubicLineSearch* ls = new CubicLineSearch(obj, m_ItMaxLine, &step);
    Optima* opt = new ConjugateGradient(ls, m_ItMax, m_Tol, m_Verbose);

    //crashes in model??: Simplex* opt = new Simplex(obj, &m, itMax, 1, .5, 2, verbose);

    // DO the optimization, output is in mOpt
    Model<double> mOpt(m);
    if(m_Verbose) cout << "starting optimization ..." << endl;
	
    mOpt	=	opt->optimizer(m);

    if(m_Verbose) 
    {
	cout <<"The number of iterations: "<< opt->numIterations() << endl;
	
	// Output Results and relative information
	ostream &outfp = cout;
	//outfp << "The best model" << endl << mOpt <<endl;
	outfp <<"The number of iterations: "<< opt->numIterations() << endl;
	outfp <<"The first residue: " << opt->firstResidue() << endl;
	outfp <<"The final residue: " << opt->finalResidue() << endl;
	outfp <<"The residue history: <available>" << endl; //<<opt->allResidue() << endl;
    }
    
    m_NIter = opt->numIterations();
    m_Residue = opt->finalResidue();
    
    SVector ret(mOpt.modParam());
    return ret;
}

/** unconstrained minimization for |Mx - y|
    \param M matrix
    \param y vector to minimize for
*/
SVector SOptimizer::minimize(const SMatrix& M, const SVector& y)
{
    using namespace linalg;
    SVector v;
    try {
	if(!m_Verbose) freopen("/dev/null","a+",stderr);
	// zeropad matrix to make enough rows 
	// (rank doesn't matter for the algorithm)
	int d = M.getNCols() - M.getNRows();
	if(d<0) d=0;
	
	linalg::Matrix mat(SMatrix(M.getNRows()+d, 
				   M.getNCols(),0.0f).insert(M));
	linalg::Vector b((SVector)SVector(M.getNRows()+d).insert(v));
	
	SVD svd(mat);
	
	if(m_Verbose) cout << "condition number of matrix A " << 
			  svd.q_cond_number() << endl;
	
	if(m_Verbose) cout << svd.q_U().q_nrows() << " != ? " << 
			  b.q_nrows() << endl;
		
//#define FOR_SOME_REASON_IT_WORKS
#ifdef FOR_SOME_REASON_IT_WORKS
	//this is beautiful, but it doesn't work!!!!!
	// Solution of Ax=b:
	linalg::Vector x = SVD_inv_mult(svd,b,SOPT_TAU);
	v = SVector(x);
/* aparently, the matrix M is pretty ill conditioned sometimes, so that values
   on S, slightly above zero still matter. Matlab can handle that, but
   our algorithm fails here :-(
*/

#else
	//so we do it by hand... (which improves results a little)
	linalg::Vector sig(svd.q_sig());
	linalg::Matrix U(svd.q_U());
	linalg::Matrix V(svd.q_V());
	
	linalg::Matrix S(sig.q_lwb(),sig.q_upb(),sig.q_lwb(),sig.q_upb());
	linalg::MatrixDA eth(S);

	//create an inverted S and skip the nearly-zero elements
	// on the diagonal
	for(register int i=eth.q_row_lwb(); i<=eth.q_row_upb(); i++)
	    for(register int j=eth.q_col_lwb(); j<=eth.q_col_upb(); j++)
	    {
		if(i == j) {
		    if(sig(i)>SOPT_TAU) eth(i,j) = 1/sig(i);
		    else eth(i,j) = 0;
		} else eth(i,j) = 0;
	    }
	
	//this sucks, too...
	//linalg::Matrix B = V * (S * (linalg::Matrix&)(transposed(U)));
	linalg::Matrix Ut = transposed(U);
	SMatrix mUt(Ut);
	SMatrix mV(V);
	SMatrix mS1(S);
	SMatrix mS = SMatrix(mV.getNCols(), mUt.getNRows(),0.0f).insert(mS1);
	
	SMatrix B = mV * mS * mUt;
	v = B*SVector(B.getNCols(),0.0f).insert(y);

#define SHOW_SUV
#ifdef SHOW_SUV
	if(m_Verbose) {
	    cout << " M: " << M << endl;
	    cout << mV.getNRows() << " " << mV.getNCols() << endl;
	    cout << mS.getNRows() << " " << mS.getNCols() << endl;
	    cout << mUt << endl;
	    cout << mUt.getNRows() << " " << mUt.getNCols() << endl;
	    
	    cout << "S^-1: " << mS << endl;
	    cout << "Ut: " << mUt << endl;
	    cout << "V: " << mV << endl;
	    cout << "V(S^-1)U': " << B << endl;
	    
	    cout << "colour: " << endl << M*v << endl;
	    cout << "y     : " << y << endl;
	    cout << "v     : " << v << "  fine." << endl;
	}
#endif	//of SHOW_SUV

#endif	//of FOR_SOME_REASON_IT_WORKS
	
	m_NIter = 0;
	m_Residue = ((M*v) - y).norm();
	
    } catch(void*)
    {
	if(!m_Verbose) freopen("/dev/stdout","a+",stderr);
    }
    if(!m_Verbose) freopen("/dev/stdout","a+",stderr);
    
    return v;
}
