#ifndef _VUSIMPLETYPES_H_
#define _VUSIMPLETYPES_H_

typedef unsigned long  dword;
typedef unsigned short word;
typedef unsigned char  byte;

// Those are fun to have ;-) Emacs reads them and takes you to the position.
#define DEBUGMSG(msg) cerr << __FILE__ << ":" << __LINE__ << ": " << msg<<endl
#define DEBUG cerr << __FILE__ << ":" << __LINE__ << ": " << endl

#define REDIRECT_CERR(file) \
{ \
  streambuf *psbuf; \
  ofstream *filestr = new ofstream(file); \
  psbuf = filestr->rdbuf(); \
  cerr.rdbuf(psbuf); \
  } // here we leak ;-)

/** Convert internal byte order between litte big endians.  Intel has
    little endian (lower byte first). Motorola and Apple have Big
    endian (higher byte at lower address). Maybe there is an assembler
    instruction to do the conversion?
*/
inline dword swizzle(dword a)
{
    register dword v;
    v  = (a & 0x000000ff) << 24;
    v |= (a & 0x0000ff00) << 8;
    v |= (a & 0x00ff0000) >> 8;
    v |= (a & 0xff000000) >> 24;
    return v;
}

/** Convert internal byte order between litte big endians. 
    Intel has little endian (lower byte first). Motorola and Apple 
    have Big endian (higher byte at lower address).
*/
inline word swizzle(word a)
{
    register word v;
    v  = (a & 0x00ff) << 8;
    v |= (a & 0xff00) >> 8;
    return v;
}

#if !defined(LINUX)

#ifndef M_E
#define M_E             2.7182818284590452354
#endif
#ifndef M_LOG2E
#define M_LOG2E         1.4426950408889634074
#endif
#ifndef M_LOG10E
#define M_LOG10E        0.43429448190325182765
#endif
#ifndef M_LN2
#define M_LN2           0.69314718055994530942
#endif
#ifndef M_LN10
#define M_LN10          2.30258509299404568402
#endif
#ifndef M_PI
#define M_PI            3.14159265358979323846
#endif
#ifndef M_PI_2
#define M_PI_2          1.57079632679489661923
#endif
#ifndef M_PI_4
#define M_PI_4          0.78539816339744830962
#endif
#ifndef M_1_PI
#define M_1_PI          0.31830988618379067154
#endif
#ifndef M_2_PI
#define M_2_PI          0.63661977236758134308
#endif
#ifndef M_2_SQRTPI
#define M_2_SQRTPI      1.12837916709551257390
#endif
#ifndef M_SQRT2
#define M_SQRT2         1.41421356237309504880
#endif
#ifndef M_SQRT1_2
#define M_SQRT1_2       0.70710678118654752440
#endif

#endif	// of !def LINUX

#ifdef CHECKNDELETE
#undef CHECKNDELETE
#endif

#define CHECKNDELETE(_object_)  \
{                         \
  if (_object_ != NULL) { \
    delete _object_;      \
    _object_ = NULL;      \
  }                       \
}                         \

/*
inline void THROW(const char *msg)
{
  cerr << "EXCEPTION: " << msg << endl;
  throw msg;
}
*/

#endif /* _VUSIMPLETYPES_H_ */
