//!The vuNormalTable class can quantize a large set of normals to a smaller collection.

#ifndef _VUNORMALTABLE_H_
#define _VUNORMALTABLE_H_

#include "vuSimpleTypes.h"
#include "vuNormalBlock.h"

class vuNormalTable
{
public:
    //!Default constructor.
    vuNormalTable();
    //!Copy constructor doing a deep copy.
    vuNormalTable(const vuNormalTable& inst);
    //!Destructor.
    ~vuNormalTable();

    //!Initializes the normal collection to an array of normals.
    /*!\param n An array of normals to add to the collection.
       \param size The number of normals in the float array.
    */
    void setCollection(const float* n, dword size);
    //!Initializes the normal collection to the given size of zero normals.
    /*!\param size The number of normals to assign to the collection.
    */
    void initCollection(dword size);
    //!Adds a normal to the collection.
    void addToCollection(const float* n);

    //!Computes the quantized normal table.
    void computeTable(void);
    //!Destroys the allocated normal table and frees memory.
    void destroyTable(void);

    //!Returns the index of the nearest normal that's in the table.
    /*!This method goes through the quantized normal table and finds
       the normal that's closest in length to the the one passed in.
       \returns The index of the nearest normal.
    */
    dword findNearest(const float* n);

    //!An assignment operator which does a deep copy
    vuNormalTable& operator=(const vuNormalTable& rhs);
    //!An access operator into the normal table.
    const float* operator[](dword index);

private:
    //!The block of quantized normals.
    vuNormalBlock* m_Block;

    float* m_Table;
    //!The size of the normal table.
    dword  m_Size;
};

#endif
