#include "vuNormalTable.h"

/*! This is the block list class for the vuNormalTable class of the vuVolume project.

 This will store a ptr to a block and a ptr to the next element of the list.

 very minimal..., it's really a node, not a list.
*/

class BList
{
public:
//! pointer to the normal block stored by this node of the list
    vuNormalBlock* m_data;
//! pointer to the next element of the list
    BList* m_next;
};

vuNormalTable::vuNormalTable()
{
    m_Table = new float[768];
    m_Block = 0;
    m_Size  = 0;
}

vuNormalTable::vuNormalTable(const vuNormalTable& inst)
{
    dword i;

    m_Table = new float[768];
    for(i=0;i<768;++i)
        m_Table[i] = inst.m_Table[i];

    m_Block = new vuNormalBlock;
    *m_Block = *inst.m_Block;

    m_Size = inst.m_Size;
}

vuNormalTable::~vuNormalTable()
{
    if (m_Table)
        delete [] m_Table;
    if (m_Block)
        delete [] m_Block;
}

void vuNormalTable::setCollection(const float* n, dword size)
{
    dword i;

    if (m_Block)
        delete [] m_Block;
    m_Block = new vuNormalBlock;
    m_Block->setSize(size);
    m_Size = 0;

    for(i=0;i<size;++i)
        m_Block->addNormal(&n[i*3]);
}

void vuNormalTable::initCollection(dword size)
{
    if (m_Block)
        delete [] m_Block;
    m_Block = new vuNormalBlock;
    m_Block->setSize(size);
    m_Size = 0;
}

void vuNormalTable::addToCollection(const float* n)
{
    m_Block->addNormal(n);
}

void vuNormalTable::computeTable(void)
{
    vuNormalBlock* left;
    vuNormalBlock* right;
    BList* head;
    BList* iter;
    BList* split;
    bool  cansplit;
    dword i;

    m_Block->computeStats();

    head = new BList;
    head->m_data = m_Block;
    head->m_next = 0;
    m_Block = 0;

    //
    // Split normals according to groups that are close
    // together (using range and standard deviation).
    //
    m_Size = 1;
    cansplit = true;
    while((m_Size<256) && cansplit)
    {
        split = head;
        iter = head->m_next;
        while(iter != 0)
        {
            if (iter->m_data->getRange() > split->m_data->getRange())
                split = iter;
            else if (iter->m_data->getRange() == split->m_data->getRange())
            {
                if (iter->m_data->getStdDev() > split->m_data->getStdDev())
                    split = iter;
            }
            iter = iter->m_next;
        }
        left = new vuNormalBlock;
        right = new vuNormalBlock;
        if (split->m_data->medianSplit(*left, *right))
        {
            delete split->m_data;
            split->m_data = left;
            iter = split->m_next;
            split->m_next = new BList;
            split->m_next->m_data = right;
            split->m_next->m_next = iter;
            ++m_Size;
        }
        else
        {
            delete left;
            delete right;
            cansplit = false;
        }
    }

    //
    // Compute the average normal in each group.
    //
    i = 0;
    iter = head->m_next;
    while(iter != 0)
    {
        iter->m_data->computeAverage(&m_Table[i]);
        iter = iter->m_next;
        i += 3;
    }

    //
    // Destroy the list that we computed.
    //
    iter = head->m_next;
    while(iter != 0)
    {
        delete iter->m_data;
        split = iter;
        iter = iter->m_next;
        delete split;
    }
}

void vuNormalTable::destroyTable(void)
{
    if (m_Table)
    {
        delete [] m_Table;
        m_Table = 0;
    }
}

dword vuNormalTable::findNearest(const float* n)
{
    float d;
    float min;
    dword index=0;
    dword i;

    min = 1000000.0f;
    for(i=0;i<m_Size*3;i+=3)
    {
        d = ((n[0]-m_Table[i])*(n[0]-m_Table[i])) + 
            ((n[1]-m_Table[i+1])*(n[1]-m_Table[i+1])) + 
            ((n[2]-m_Table[i+2])*(n[2]-m_Table[i+2]));
        if (d < min)
        {
            index = i/3;
            min = d;
        }
    }

    return index;
}

vuNormalTable& vuNormalTable::operator=(const vuNormalTable& rhs)
{
    if (this != &rhs)
    {
        dword i;

        for(i=0;i<768;++i)
            m_Table[i] = rhs.m_Table[i];

        if (m_Block)
            delete [] m_Block;
        m_Block = new vuNormalBlock;
        *m_Block = *rhs.m_Block;
    }
    return *this;
}

const float* vuNormalTable::operator[](dword index)
{
    return &m_Table[index*3];
}
