#ifndef _VUNORMALBLOCK_H_
#define _VUNORMALBLOCK_H_

#include "vuSimpleTypes.h"

class vuNormalBlock
{
public:
    //!Default constructor creating a null table.
    vuNormalBlock();
    //!Copy constructor doing a deep copy.
    vuNormalBlock(const vuNormalBlock& inst);
    //!Destructor
    ~vuNormalBlock();

    //!Sets the size of the normal block.
    void setSize(dword size);
    //!Returns the size of the normal block.
    dword getSize(void) const;
    //!Returns the range of the normals.
    float getRange(void) const;
    //!Returns the standard deviation between the normals.
    float getStdDev(void) const;

    //!Adds a normal to the normal block.
    void addNormal(const float* norm);

    //!Computes the range and standard deviation of the normals.
    void computeStats(void);
    //!Splits the normal block about the median.
    bool medianSplit(vuNormalBlock& left, vuNormalBlock& right);
    //!Computes the average length of the normals.
    void computeAverage(float* f) const;

    //!An assignment operator doing a deep copy.
    vuNormalBlock& operator=(const vuNormalBlock& rhs);

private:

	/** this performs a quicksort partition on m_dim,

	ie, this will m_th component of each element between p and r (inclusive) in the block
	and will swap elements to ensure that the all elements that have an m_th component
	less than the initial m_th component at position p will be before all other elements in the range
	of p..r
	*/
    int Partition(int p, int r);
	/* this performs a quicksort partition except that it randomly picks the element that it will pivot on

	ie, it picks a random element between p and r (inclusive)and swaps that element with element p and performs a partition
	on p..r. */
    int RandomPartition(int p, int r);
    	/** this will perform a quicksort on the elements between p and r (inclusive)*/
    void QuickSort(int p, int r);

private:
    dword  m_Size; //!< the size of the block
    dword  m_Current; //!< the current element that you are looking at
    float* m_Norms; //!< the buffer that stores the normals
    dword  m_Dim; //!< the dimension that is being looked at currently (ie, 0, 1, or 2)
    float  m_Range; //!< the range of the normals
    float  m_StdDev; //!< the standard deviation between the normals
};

#endif
