/*! This class computes the uniform distribution of n points on a surface
    of a sphere.

    It's a slightly modificated version of Steven Kilthau's UDSphere. -ms-
*/

#ifndef __vuUDSphere_H__
#define __vuUDSphere_H__

#include <math.h>

class Point3d
{
public:
  Point3d() { fx = 0; fy = 0; fz = 0; }
  ~Point3d() {}

  void set(double xx, double yy, double zz)
    {
      x = xx;
      y = yy;
      z = zz;
      theta = atan2(y, x);
      phi = acos(z);
    }

  void reset(void)
    {
      theta = atan2(y, x);
      phi = acos(z);
    }

  bool operator==(Point3d& rhs) { return phi == rhs.phi; }
  bool operator<(Point3d& rhs)  { return phi < rhs.phi;  }
  bool operator>(Point3d& rhs)  { return phi > rhs.phi;  }
  bool operator<=(Point3d& rhs) { return phi <= rhs.phi; }
  bool operator>=(Point3d& rhs) { return phi >= rhs.phi; }

 public:
  // Rectangular coordinates
  double x,y,z;    // x,y,z

  // Spherical coordinates
  double phi;      // 0..pi
  double theta;    // 0..2*pi

  // Forces
  double fx, fy, fz;
};

class vuUDSphere
{
 public:
  vuUDSphere(int _size=256);
  ~vuUDSphere(void);

  bool     advancePoints(void);
  bool     doesFileExist(void);
  void     writeToFile(void);
  void     readFromFile(void);
  int      getSize(void);
  Point3d  getPointAt(int idx);
  void     calculate(void);
  void     lazyCalculate(void); // trys to read from file, otherwise calculate

 private:
  Point3d* m_P;
  double   m_dt;
  double   m_Tolerance;
  int      m_Size;

  void makeRandomPoint(Point3d& p);
  void initPoints(void);
  void computeForces(Point3d& p0, Point3d& p1);
};

#endif /* __vuUDSphere_H__ */
