#include "vuTimer.h"
#include "vuSimpleTypes.h"
#include <sys/time.h>

#ifdef __MINGW32__
#include <windows.h>
#warning TODO: find a better solution
int gettimeofday(struct timeval* tp, void* tzp)
{
	DWORD t = timeGetTime();
	tp->tv_sec = t / 1000;
	tp->tv_usec = t % 1000;
	return 0;
}
#endif

unsigned long vuTimer::getMilliSeconds()
{
  static struct timeval time;
 
  gettimeofday(&time, 0);
  
  return (unsigned long)time.tv_sec*1000 + (unsigned long)time.tv_usec/1000;
}

double vuTimer::getMilliSecondsAsDouble()
{
  static struct timeval time;
 
  gettimeofday(&time, 0);
  
  return (double)time.tv_sec*1000 + (double)time.tv_usec/1000.0f;
}


vuTimer::vuTimer()
{
  start();
}

void vuTimer::start()
{
  m_StartTime = vuTimer::getMilliSeconds();
  m_EndTime   = m_StartTime;
}

void vuTimer::stop()
{
  m_EndTime = vuTimer::getMilliSeconds();
}

unsigned long vuTimer::getInterval()
{
  return m_EndTime - m_StartTime;
}

