/**A string class for the volume tree that's lightweight and doesn't conflict with wxWindows
or the standard library. */

#ifndef _VUSTRING_H_
#define _VUSTRING_H_

#include <iostream.h>
#include "../vuSimpleTypes.h"

/** A string class for the volume tree that's lightweight and doesn't conflict with wxWindows
or the standard library. */
class vuString
{
public:
    //!Creates an empty vuString.
	vuString();
    //!Creates a one character vuString.
    vuString(char c);
    //!Creates a vuString holding the given c string.
    vuString(const char *s);
    //!Creates a vuString representing the integer.
	vuString(int i);
    //!Creates a vuString representing the long.
    vuString(long l);
    //!Creates a vuString represeting the unsinged long.
	vuString(unsigned long ul);
    //!The copy constructor.
	vuString(const vuString& s);
    //!The destructor.
	~vuString();

    //!Returns the length of the vuString.
	dword getLength(void) const;
    //!Returns true if the string is empty.
    bool isEmpty() const;
    //!Returns true if the string has the prefix. -ms-
    bool hasPrefix(const vuString &prefix) const;
    //!Returns true if the string has the suffix. -ms-
    bool hasSuffix(const vuString &suffix) const;
    //!Empties the string and sets it to zero length.
    /*!\return A reference to the current instance.*/
    vuString& empty(void);

    /*** some file name related methods ***********************/
    //! returns the last path component,
    //! e.g. '/etc/host.conf' -> 'host.conf' -ms-
    vuString getLastPathComponent() const;

    //! returns the path extension,
    //! e.g. '/etc/host.conf' -> 'conf'
    //!      '/etc/fstab'     -> '' (empty string) -ms-
    vuString getPathExtension() const;

    /**********************************************************/

    //!The equivalent of the strcmp() c function for the vuStrings class.
	int compare(const vuString& s) const;
    //!Returns a substring of the instance.
    vuString substr(dword start,dword end) const;

    //!Assignment operator.
	vuString& operator=(const vuString& rhs);
    //!Returns a new vuString with the two strings concatenated.
    vuString operator+(const vuString& rhs) const;
    //!Appends the right hand side to the vuString instance.
    vuString& operator+=(const vuString& rhs);
    //!Appends the right hand side to the vuString instance.
    vuString& operator<<(const vuString& rhs);
    //!Returns a reference to the chosen character in the string.
    char& operator[](dword index);
    //!Returns the chosen character in the string.
    char operator[](dword index) const;
    /** equivalence operator,

        this returns true if the two strings are equivalent.
	otherwise it returns false. */
    bool operator==(const vuString& rhs) const;

    	/** inequality operator,

	     this returns true if the two strings are equivalent.
	     otherwise, it returns false. */
	bool operator!=(const vuString& rhs) const;

	/** Less than operator,

	    This returns true if rhs is greater than this, alphabetically
	    speaking in ASCII, and false otherwise. */
	bool operator<(const vuString& rhs) const;

	/** greater than operator,

            This returns true if rhs is less than this, alphabetically
	    speaking in ASCII, and false otherwise. */
	bool operator>(const vuString& rhs) const;

	/** less than or equivalent operator,

	    This returns true if rhs is greater than or equal to this,
	    alphabetically speaking, in ASCII, and false otherwise.  */
	bool operator<=(const vuString& rhs) const;

        /** greater than or equivalent operator,

	    This returns true is the rhs is less than or equal to this,
	    alphabetically speaking, in ASCII, and false otherwise.  */
	bool operator>=(const vuString& rhs) const;

    //!Assignment operator for c strings.
	vuString& operator=(const char* rhs);
    //!Returns a new vuString with the c string concatenated to the end of the instance.
    vuString operator+(const char* rhs) const;
    //!Appends the cstring to the instance.
    vuString& operator+=(const char* rhs);
    //!Appends the cstring to the instance.
    vuString& operator<<(const char* rhs);

        /** Equivalence operator,

	    This returns true if the two strings are equivalent otherwise. */
	bool operator==(const char* rhs) const;

	/** Inequivalence operator,

	    This returns true if the two strings are not equivalent otherwise. */
	bool operator!=(const char* rhs) const;

	/** Less than operator,

	    This returns true if this string is less than rhs  (in the
	    ASCII sense, and false otherwise. */
	bool operator<(const char* rhs) const;

	/** Greater than operator,

	    This returns true if this string is greater than rhs, in the ASCII
	    comparison sense.  */
	bool operator>(const char* rhs) const;

	/** Less than equivalence,

	    This returns true if this string is less than rhs or equal to, in
	    the ASCII sense. */
	bool operator<=(const char* rhs) const;

	/** Greater than or equal to operator,

	    This returns true if this string is greater than or equal to int the
	    ASCII sense.  */
	bool operator>=(const char* rhs) const;

    //!implicit conversion to C string
    operator const char*() const { return m_Data; };
    //!explicit conversion to C string (use this with printf()!)
    const char* c_str() const { return m_Data; };

    /** This extract the data in this and puts it into the returned stream. */
    friend ostream& operator<<(ostream& in,const vuString& rhs);
    /** Addition Operator,

        This concatenates the two strings together and returns the concatentated string. */
    friend vuString operator+(const char *str,const vuString &rhs);

private:
	char* m_Data;	//!< This is the buffer that stores the string.
};

#endif
