#include "vuString.h"

#include <iostream.h>
#include <string.h>
#include <stdio.h>

vuString::vuString()
{
	m_Data = new char[1];
	m_Data[0] = '\0';
}

vuString::vuString(char c)
{
    m_Data = new char[2];
    m_Data[0] = c;
    m_Data[1] = '\0';
}

vuString::vuString(const char* s)
{
    if (s != 0)
    {
	    m_Data = new char[strlen(s) + 1];
	    strcpy(m_Data, s);
    }
    else
	{
       	m_Data = new char[1];
		m_Data[0] = '\0';
	}
}

vuString::vuString(int i)
{
	char temp[12];

	sprintf(temp,"%i",i);
    m_Data = new char[strlen(temp) + 1];
    strcpy(m_Data, temp);
}

vuString::vuString(long l)
{
	char temp[12];

	sprintf(temp,"%li",l);
    m_Data = new char[strlen(temp) + 1];
    strcpy(m_Data, temp);
}

vuString::vuString(unsigned long ul)
{
	char temp[12];

	sprintf(temp,"%lu",ul);
    m_Data = new char[strlen(temp) + 1];
    strcpy(m_Data, temp);
}

vuString::vuString(const vuString& s)
{
    m_Data = new char[strlen(s.m_Data) + 1];
    strcpy(m_Data, s.m_Data);
};

vuString::~vuString()
{
    delete [] m_Data;
}

dword vuString::getLength(void) const
{
	return strlen(m_Data);
}

bool vuString::isEmpty() const
{
    return (strlen(m_Data)==0);
}

vuString& vuString::empty(void)
{
    (*this) = "";

    return *this;
}

int vuString::compare(const vuString& s) const
{
	return strcmp(m_Data, s.m_Data);
}

vuString vuString::substr(dword start,dword end) const
{
    if (isEmpty())
        return "";
    else if (start >= getLength())
        return "";
    else if (start > end)
        return "";
    else
    {
        //fix the end index.
        if (end >= getLength()) end = getLength()-1;
        //Create a string to hold all the characters.
        char *newstr = new char[end-start+2];
        //Copy over the string.
        memcpy(newstr,m_Data+start,end-start+1);
        //Append the end of string character.
        newstr[end-start+1]='\0';
        return newstr;
    }
}

vuString& vuString::operator=(const vuString& rhs)
{
	if (this != &rhs)
	{
        delete [] m_Data;

	    m_Data = new char[strlen(rhs)+1];
	    strcpy(m_Data, rhs.m_Data);
	}

	return *this;
}

char& vuString::operator[](dword index)
{
	return m_Data[index];
}

char vuString::operator[](dword index) const
{
	return m_Data[index];
}

vuString vuString::operator+(const vuString& rhs) const
{
	vuString str = *this;

	str += rhs;
	return str;
}

vuString& vuString::operator+=(const vuString& rhs)
{
    int len = strlen(m_Data) + strlen(rhs.m_Data);
    char *temp = new char[len + 1];
    strcpy(temp,m_Data);
    strcpy(temp+strlen(m_Data),rhs.m_Data);
    delete [] m_Data;
    m_Data = temp;

    return *this;
}

vuString& vuString::operator<<(const vuString& rhs)
{
    *this += rhs;
    return *this;
}

bool vuString::operator==(const vuString& rhs) const
{
	return (strcmp(m_Data,rhs.m_Data) == 0);
}

bool vuString::operator!=(const vuString& rhs) const
{
    return (strcmp(m_Data,rhs.m_Data) != 0);
}

bool vuString::operator<(const vuString& rhs) const
{
    return (strcmp(m_Data,rhs.m_Data) < 0);
}

bool vuString::operator>(const vuString& rhs) const
{
    return (strcmp(m_Data,rhs.m_Data) > 0);
}

bool vuString::operator<=(const vuString& rhs) const
{
    return (strcmp(m_Data,rhs.m_Data) <= 0);
}

bool vuString::operator>=(const vuString& rhs) const
{
    return (strcmp(m_Data,rhs.m_Data) >= 0);
}

vuString& vuString::operator=(const char * rhs)
{
	delete [] m_Data;

    m_Data = new char[strlen(rhs) + 1];
    strcpy(m_Data, rhs);

	return *this;
}

vuString vuString::operator+(const char* rhs) const
{
	vuString str = *this;

	str += rhs;
	return str;
}

vuString& vuString::operator+=(const char* rhs)
{
    int len = strlen(m_Data) + strlen(rhs);
    char *temp = new char[len + 1];
    strcpy(temp,m_Data);
    strcpy(temp+strlen(m_Data),rhs);
    delete [] m_Data;
    m_Data = temp;

    return *this;
}

vuString& vuString::operator<<(const char* rhs)
{
    *this += rhs;
    return *this;
}

bool vuString::operator==(const char* rhs) const
{
	return (strcmp(m_Data, rhs) == 0);
}

bool vuString::operator!=(const char* rhs) const
{
    return (strcmp(m_Data, rhs) != 0);
}

bool vuString::operator<(const char* rhs) const
{
    return (strcmp(m_Data, rhs) < 0);
}

bool vuString::operator>(const char* rhs) const
{
    return (strcmp(m_Data, rhs) > 0);
}

bool vuString::operator<=(const char* rhs) const
{
    return (strcmp(m_Data, rhs) <= 0);
}

bool vuString::operator>=(const char* rhs) const
{
    return (strcmp(m_Data, rhs) >= 0);
}

ostream& operator<<(ostream& os,const vuString& rhs)
{
    os << rhs.m_Data;
    return os;
}

vuString operator+(const char *str,const vuString& rhs)
{
	vuString newstr = str;
	newstr += rhs;

    return newstr;
}

bool vuString::hasPrefix(const vuString &prefix) const
{
  dword cnt = prefix.getLength();
  if (getLength() < cnt) return false;

  for (dword i=0; i<cnt; i++) {
    if (m_Data[i] != prefix[i]) return false;
  }
  return true;
}

bool vuString::hasSuffix(const vuString &suffix) const
{
  dword cnt  = suffix.getLength();
  dword cnt2 = getLength();

  if (cnt2 < cnt) return false;

  for (dword i=1; i<=cnt; i++) {
    if (m_Data[cnt2-i] != suffix[cnt-i]) return false;
  }
  return true;
}

vuString vuString::getLastPathComponent() const
{
  vuString result;

  dword pos = 0; // last occurance of '/'
  dword cnt = getLength();

  for (dword i=0; i<cnt; i++) {
    if (m_Data[i] == '/') pos = i+1;
  }
  return substr(pos, cnt-1);
}

vuString vuString::getPathExtension() const
{
  vuString result;

  dword pos = getLength(); // last occurance of '.'
  dword cnt = getLength();

  for (dword i=0; i<cnt; i++) {
    if (m_Data[i] == '.') pos = i+1;
  }
  return substr(pos, cnt-1);
}
