#ifndef _VUSPECTRALIMAGE_H_
#define _VUSPECTRALIMAGE_H_

#include "vuImage.h"
#include "vuColour7a.h"
#include "vuColourRGBa.h"

/** Hold a spectrum for each pixel on the screen. 
    Is used to apply post-illumination.
    The reference to vuColour7a is a typecast that stands for 
    the color model used in the currently compiled version.
   \todo relate it more to the framebuffer provided by a future version
   of vuDrawTools
 */
class vuSpectralImage  
{
public:
	/** constructor */
	vuSpectralImage();
	/** destructor */
	virtual ~vuSpectralImage();
        /** \return light source currently used for illumination */
	const vuColour7a& get_light() const;
	/** get colour from specific point 
	    \return false if xy out of range */
	bool get_xy(int x, int y, vuColour7a & col) const {
	    col = spix[x+maxx*y];
	    return true;
	}
		
	//! direct read access to the float array at position (x,y)
	float* get_xy_data(int x, int y) {
	    return spix[x+maxx*y].getData();
	}
	/** get extents of image */
	void get_extents(int & sizx, int & sizy);
	/** initialize spectral framebuffer of given size
	    \todo meaningful concept for framebuffer resize */
	bool init(int sizx, int sizy);
	/** set a specific light source 
	    this source is used to apply post illumination */
	void set_light(vuColour7a light);
	/** performs post illumination
	    This functions applies the light source given by set_light()
	    and transforms the resulting colors to RGB which is written
	    into the buffer.
	    \param buf pointer to byte buffer
	    \param size of buffer in byte (unsigned char)
	    \return if(buf == NULL || size<3*maxx*maxy) return false */
	bool get_rgb(byte *buf, int size) const;
	//!returns a post-illuminated image in img
	bool getRGBImage(vuImage& img) const;
	
	/** set spectral color information for a point */
	bool set_xy(int x, int y, const vuColour7a col) {
	    if(x<0 || y<0 || x>=maxx || y>=maxy) return false;
	    spix[x+maxx*y] = col;
	    return true;
	}
	/** set mask to value */
	void set_mask(bool value=true);
	/** create a mask to deactivate all pixels with a zero spectrum */
	void create_black_mask();
private:
	/** stores the light source */
	vuColour7a light;
	/** pointer to spectral frame buffer */
	vuColour7a *spix;
	/** mask to avoid calculating black points */
	bool *mask;
	/** extents of the framebuffer */
	int maxx,maxy;
};

#endif
