#include <stddef.h>
#include "vuSpectralImage.h"
#include "vuColourXYZa.h"

//////////////////////////////////////////////////////////////////////


vuSpectralImage::vuSpectralImage()
{
  spix = NULL;
  mask = NULL;
  maxx = maxy = 0;
  init(0,0);
}

vuSpectralImage::~vuSpectralImage()
{
    if(spix) delete [] spix;
    spix = NULL;
    if(mask) delete [] mask;
    mask = NULL;
}

bool vuSpectralImage::init(int sizx, int sizy)
{
    if(maxx != sizx || maxy != sizy) {
	maxx=sizx;
	maxy=sizy;
	if(spix) delete [] spix;
	if(mask) delete [] mask;
	if(sizx && sizy)
	{
	    spix = new vuColour7a[maxx*maxy];
	    if(!spix) return false;
	    mask = new bool[maxx*maxy];
	    if(!mask) return false;
	}
    }
    if(sizx && sizy)
    {
	int i;
	for(i=0; i<maxx*maxy; i++)
	    spix[i] = 0.0f;
	set_mask(false);
    } else { spix = NULL; mask = NULL; }
    return true;
}

void vuSpectralImage::set_mask(bool value)
{
    int i;
    for(i=0; i<maxx*maxy; i++)
	mask[i] = 0;
}

void vuSpectralImage::create_black_mask()
{
    int i;
    for(i=0; i<maxx*maxy; i++)
	mask[i] = spix[i].maxComponent()>0.00001f;
}

bool vuSpectralImage::get_rgb(byte *buf, int size) const
{
  int sizeXY = maxx*maxy;
  if(spix == NULL || buf == NULL || size<3*sizeXY) return false;
  vuColourRGBa rgba;
  const vuColour7a *spec = spix;
  int i;
  for(i=0;i<sizeXY;i++, spec++)
  {
      if(mask[i]) {
	  rgba.from(*spec*light);
	  rgba.clampTo01();
	  *(buf++)=(unsigned char)(255.f*rgba[0]);
	  *(buf++)=(unsigned char)(255.f*rgba[1]);
	  *(buf++)=(unsigned char)(255.f*rgba[2]);
      } else {
	  *(buf++)= 0; *(buf++)= 0; *(buf++)= 0;
      }
  }
  return true;
}

bool vuSpectralImage::getRGBImage(vuImage& img) const
{
    if(img.getWidth() != maxx ||
       img.getHeight() != maxy)
	img.init(maxx,maxy);
    if(!get_rgb(img.get_buffer(), img.getWidth()*img.getHeight()*3))
	return false;
    else
	return true;
}

void vuSpectralImage::set_light(vuColour7a light)
{
	this->light = light;
}


void vuSpectralImage::get_extents(int &sizx, int &sizy)
{
	sizx=maxx;
	sizy=maxy;
}

const vuColour7a& vuSpectralImage::get_light() const
{
	return light;
}
