
// File:   vuRay.h
// Author: Steve Kilthau
// Date:   August, 1999
//
// Adapted to vuVolume by Steven Bergner, 2001

#ifndef _VURAY_H_
#define _VURAY_H_

#include "../vuLinAlg/vuVector.h"

//! Defines a ray with start point and direction
/*!
 This file defines a ray class.  A vuRay is specified by
 a start position and a direction (and a pointer to the
 object within which the start position resides, if it
 is in the interior of an object).
*/
class vuRay
{
public:
    vuRay();                //!< Default constructor
    vuRay(const vuRay &r);    //!< Copy constructor
    ~vuRay();               //!< Destructor

    //! Assignment operator
    vuRay& operator=(const vuRay &rhs);

    //! Advances the m_Position of the ray one step into m_Direction
    void advance() {
	m_Position += m_Direction;
    };

public:
    vuVector   m_Position;      //!< The origin of the ray (public)
    vuVector   m_Direction;     //!< The direction of the ray (public)
};

#endif
