#ifndef _VU_PROGRESS_HANDLER_H_
#define _VU_PROGRESS_HANDLER_H_

/* This class provides an abstract interface (protocol) to the
   wxProgressDialog callback. The reason for this construct is the desired
   independency of libvuGeneral to other libs (e.g libwxWindows).

   A real implementation of this protocal can be found in 
   wxUIElements/vuSimpleProgressHandler.[h,cpp]. -ms-
*/

class vuProgressHandler {
 public:

  /*! example (two nested functions):

           preprocess(handler) {
             int oldRange = handler.getRange();
	     int newRange = oldMax/3;

	     handler.setRange(newRange); // range is shorter for sub calls
             for (int i=0; i<3; i++) {
	       subPreprocess(handler);
             }	     
	     handler.setRange(oldRange); // restore old range
           }

	   subPreprocess(handler) {
	     int step     = handler.getRange() / 10;
	     int progress = handler.getCurrentProgress();

	     for (i=0; i<10; i++) {
	        write(i); // do some stuff
		progress += step
                handler.update(progress, "some update information")
	     }
           }
  */

  /*! The range specifies the value, which represents the '100% completed'
      mark. The range can be manipulated to allow nest calls 
      (see example above).

      \note The range can NOT be increased, but only divided into smaller parts
  */
  virtual void setRange(int range) = 0;
  virtual int  getRange()          = 0;

  /*! returns the current progress value, which is updated by 
      update(int, char*)
   */
  virtual int  getCurrentProgress() = 0;

  /*! updates the progress bar and additionally gives some message */
  virtual bool update(int newProgressValue,  const char* msg=0) = 0;
};

#endif
