#ifndef _VUMAP_H_
#define _VUMAP_H_

#include <iostream>
#include <vuSimpleTypes.h>

using namespace std;

/** Class to handle remapping intensities.
    Can be used to window intensity ranges or to enhance lower intensities
    or to equalize histograms.
    Should use vuHistogram to setup some specific maps.
*/
class vuMap {
 public:
    /** Constructor. */
    vuMap();
    /*Destructor. */
    virtual ~vuMap();

    /** Create a mapping to window an intensity range.
	The range from start to end will be mapped to values from startVal
	to endVal. The range outside [start, end] is set to constant 
	startval and endval accoringly. */
    void createRamp(word start, word startval, word end, word endval);

    /** Identity mapping */
    void createIdentity();

    //Other function for different kinds of mappings should be added

    /** Get mapped value for entry 'index'
	No range checking is performed. */
    word operator[](word index) const
	{return m_Map[index]; }
    /** Allows to modify entry.
	No range checking is performed. */
    word& operator[](word index)
	{return m_Map[index]; }

    friend ostream& operator<<(ostream& os, const vuMap& map);

    friend istream& operator>>(istream& is, vuMap& map);

 protected:
    //! Intensity map
    word m_Map[1<<16];
};

#endif
