#include "vuMap.h"

vuMap::vuMap()
{
    createIdentity();
}

vuMap::~vuMap()
{}

void vuMap::createRamp(word start, word startval, word end, word endval)
{
    if(end<start) return;
    dword i;
    for(i=0; i<start; i++)
	m_Map[i] = startval;
    word w;
    word range = end-start;
    for(i=start, w=0; i<end; i++, w++)
	m_Map[i] = ((long)startval*(range-w) + endval*w)/range;
    for(i=end; i<(1<<16); i++)
	m_Map[i] = endval;
}

void vuMap::createIdentity()
{
    dword i;
    for(i=0; i<(1<<16); i++)
	m_Map[i] = (word)i;
}

ostream& operator<<(ostream& os, const vuMap& map)
{
    dword i;
    for(i=0; i<(1<<16); i++)
	os << map[i] << endl;
    return os;
}

istream& operator>>(istream& is, vuMap& map)
{
    dword i;
    for(i=0; i<(1<<16); i++)
	is >> map[i];
    return is;
}
