/*	Modified by Christoper Steinbach
	Modified March 2002

	Modified to add capabilities for fast read and write
	for PPM files and other data sets.

	added functions such as set_extents ()
				set_data ()
				setrgb ()
				set_xy (x, y, r, g, b);

	I added some of the functions because I needed to read from
	a file into a buffer, but the header was not a part of the
	buffer that image should contain, and
*/

#ifndef _vuImage_H_
#define _vuImage_H_

#include "vuSimpleTypes.h"
#include "vuColourRGBa.h"

#include <string.h>

namespace ns_vu1112113 {
};
/** Hold a spectrum for each pixel on the screen.
    Is used to apply post-illumination.
    The reference to ColourType is a typecast that stands for
    the color model used in the currently compiled version.
   \todo relate it more to the framebuffer provided by a future version
   of vuDrawTools
 */
class vuImage
{
 public:
  enum vuImageFormat {
    vuBMP_RGBA,  // 32 bit rgba (alpha is ignored!!!)
    vuBMP_GREY   //  8 bit monochrome
  };

public:
	/** constructor */
	vuImage(dword width=0, dword height=0);
	/** destructor */
	virtual ~vuImage();
        /** copy constructor */
	vuImage(const vuImage &other);
	/** initialize spectral framebuffer of given size */
	bool init(int sizx, int sizy);

	/** get extents of vuImage */
	void get_extents(int & sizx, int & sizy);
	/** this will set the extents of the buffer spix, but it will
	    not delete the memory pointed to by spix and will
	    notallocate new memory at spix.*/
	void set_extents (int sizx, int sizy);
	/** set spectral color information for a point */
	bool set_xy(int x, int y, const vuColourRGBa& col);
	/** This will set pixel (x, y) to have colour (r, g, b)... I added this
		since it would be faster than the previous method since then I
		wouldn't have to divide and multiply each pixel to get the proper
		value, and this would save me time. */
	bool set_xy(int x, int y, unsigned char r,  unsigned char g,  unsigned char b);
	/** get colour from specific point
	    \return false if xy out of range */
	bool get_xy(int x, int y, vuColourRGBa & col);
	/** returns the framebuffer */
	const byte* get_rgb() const;
	/** returns the framebuffer for modification */
	byte* get_buffer();

	/** This will copy the contents of rgb into spix (make sure that rgb is of the
		appropriate size and dimensions first). */
	bool set_rgb(byte* rgb);

	/** This will set the buffer from start up to start + number_copied bytes
		from rgb */
	void set_rgb (int start, int number_copied, byte* rgb);

	/** This will overwrite spix with rgb without first deleting the buffer spix */
	void elim_data (byte* rgb);

	/** This will delete spix and set spix equal to rgb. */
	bool set_data (byte* rgb);

	/** This will return the differences between img1 and img2 and store the signed
		difference in the array pointed to by temp*/
	friend bool get_difference (vuImage &img1, vuImage &img2, int* temp);
	int getWidth () const;
	int getHeight () const;

	/** Blits the image to the screen. (to blit means kinda draw)*/ 
	void blit(int x=0, int y=0);
        /** Clears the image with color(r,g,b) and blits it to the screen */
	void clear(const byte r = 0, const byte g = 0, const byte b = 0);



	//! openGl related methods
	void initOpenGL();
	void glResize(dword width, dword height);	
	void glRender();

        /** file write/read access */

        bool writeToFile(const char *fileName,  vuImageFormat fmt=vuBMP_RGBA);
	bool readFromFile(const char *fileName, vuImageFormat fmt=vuBMP_RGBA);
	
private: // member data

	/** pointer to spectral frame buffer */
	byte *spix;

	/** extent of the framebuffer in the x direction */
	int maxx;

	/** extent of the framebuffer in the y direction */
	int maxy;


 public: // operator overloading
	vuImage operator=(const vuImage &other);
	vuImage &operator+=(vuImage &other);
	vuImage &operator*=(float scale);

 private:
	void _copy(const vuImage &other);
};

//};

#endif
