// vuImage.cpp: Implementierung der Klasse vuImage.
//
//////////////////////////////////////////////////////////////////////
#include <stddef.h>
#include "vuImage.h"
#include <GL/gl.h>
#include <Paintlib/planybmp.h>
#include <Paintlib/plbmpdec.h>
#include <Paintlib/plbmpenc.h>


//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

vuImage::vuImage(dword width, dword height)
{
  spix = NULL;
  maxx = 0;
  maxy = 0;
  init(width, height);
}

vuImage::~vuImage()
{
    if(spix) {
	delete [] spix;
	spix = NULL;
    }
} 

vuImage::vuImage(const vuImage &other)
{
  operator=(other);
}


bool vuImage::init(int sizx, int sizy)
{
    if ((sizx != maxx) || (sizy != maxy)) {
	maxx=sizx;
	maxy=sizy;
	if(spix) delete [] spix;
	if(sizx && sizy)
	{
	    spix = new byte[maxx*maxy*3];
	    int c;
	    byte *bp = spix;
	    for(c=maxx*maxy*3;c>0;c--,bp++) *bp=0;
	    if(!spix) return false;
	} else spix = NULL;
	return true;
    } else return false;
}

bool vuImage::set_xy(int x, int y, const vuColourRGBa& col)
{
	if(x<0 || y<0 || x>=maxx || y>=maxy) return false;
	vuColourRGBa rgb(col);
	rgb.clampTo01();
	byte *pix = &spix[(maxx*y+x)*3];
	pix[0] = byte(255.0f * rgb[0]);
	pix[1] = byte(255.0f * rgb[1]);
	pix[2] = byte(255.0f * rgb[2]);

//	if (int (pix [0]) != 0)
//		cout << "pix" << int (pix [0]) << ' ' << int (pix [1]) << ' ' << int (pix [2]) << ' ';
	return true;
}

bool vuImage::set_xy(int x, int y, unsigned char r, unsigned char g, unsigned char b)
{
	if(x<0 || y<0 || x>=maxx || y>=maxy) return false;
	byte *pix = &spix[(maxx*y+x)*3];
	pix[0] = byte(r);
	pix[1] = byte(g);
	pix[2] = byte(b);
	return true;
}

bool vuImage::get_xy(int x, int y, vuColourRGBa &col)
{
	if(x<0 || y<0 || x>=maxx || y>=maxy) return false;
	col[0] = 255.0f/spix[(maxx*y+x)*3];
	col[1] = 255.0f/spix[(maxx*y+x)*3+1];
	col[2] = 255.0f/spix[(maxx*y+x)*3+2];
	return true;
}

const byte* vuImage::get_rgb() const
{
  return spix;
}

byte* vuImage::get_buffer()
{
  return spix;
}

void vuImage::get_extents(int &sizx, int &sizy)
{
	sizx=maxx;
	sizy=maxy;
}

void vuImage::set_extents (int sizx, int sizy)
{
	maxx = sizx;
	maxy = sizy;
}

bool vuImage::set_rgb (byte* rgb)
{
	memcpy(spix, rgb, 3 * maxx * maxy);

	return true;
}

void vuImage::set_rgb (int start, int number_copied, byte* rgb)
{
	memcpy(&(spix [start]), rgb, number_copied);
}

bool vuImage::set_data (byte* rgb)
{
	delete [] spix;

	spix = rgb;

	return true;
}

void vuImage::elim_data (byte* rgb)
{
	spix = rgb;
}

int vuImage::getWidth () const
{
	return maxx;
}

int vuImage::getHeight () const
{
	return maxy;
}

void vuImage::clear(const byte r, const byte g, const byte b)
{
  byte* p      = spix;

  for (int i=maxx*maxy; i>0; i--) {
    *(p++) = r;
    *(p++) = g;
    *(p++) = b;
  }
}


void vuImage::blit(int x, int y) 
{
    if(maxx && maxy && spix) {
	//glPixelStorei(GL_UNPACK_ROW_LENGTH, maxx);
	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
	//glPixelZoom(1,1);//xscale, yscale);
	glRasterPos2i(x,y);
	glDrawPixels(maxx,
		     maxy,
		     GL_RGB,
		     GL_UNSIGNED_BYTE,
		     spix);
    }
}

/* ************************************************************************* */
/* *** openGl related  things ********************************************** */
/* ************************************************************************* */

void vuImage::initOpenGL(void)
{
  glDisable(GL_LIGHTING);
}

void vuImage::glResize(dword width, dword height)
{
  if (maxx == 0 || maxy == 0)
    cerr << "WARNING: vuImage.glResize(): width or height is 0." << endl;
  glPixelZoom((float)width/maxx,(float)height/maxy);
}

void vuImage::glRender()
{
  if (maxx && maxy && spix)
    glDrawPixels(maxx, maxy, GL_RGB, GL_UNSIGNED_BYTE, spix);
}

/* ************************************************************************* */
/* ************************************************************************* */
/* ************************************************************************* */

#if 0
bool vuImage::writeToFile(const char *fileName, vuImageFormat fmt)
{
  PLAnyBmp     bmp;
  PLBmpEncoder encoder;
  PLBYTE       **dest;
  byte         *src;
  int          bit = (fmt == vuBMP_GREY) ? 8 : 32;

  bmp.Create(maxx, maxy, bit, false);
  dest = bmp.GetLineArray();
  src  = get_buffer();

  for (int j=0; j<maxy; j++) {
    for (int i=0; i<maxx; i++) {
      PLBYTE *tmp = dest[j];
     
      if (fmt == vuBMP_GREY) {
	tmp[i] = (*src+*(src+1)+*(src+2)) / 3;
	src += 3;
      }
      else {
	tmp[4*i+0] = *(src++);
	tmp[4*i+1] = *(src++);
	tmp[4*i+2] = *(src++);
      }
    }
  }

  try {
    encoder.MakeFileFromBmp(fileName, &bmp);
  }
  catch (PLTextException &excep) {
    cerr << "PLTextException catched..." << excep.GetCode() << endl;
    return false;
  }
  catch(...) {
    cerr << "catched...." << endl;
    return false;
  }
  return true;
}

bool vuImage::readFromFile(const char *fileName, vuImageFormat fmt)
{
  PLAnyBmp     bmp;
  PLBmpDecoder decoder;
  PLBYTE       **src;
  byte         *dest;

  try {
    decoder.MakeBmpFromFile(fileName, &bmp);
  }
  catch (PLTextException &excep) {
    cerr << "PLTextException catched..." << excep.GetCode() << endl;
    return false;
  }
  catch(...) {
    cerr << "catched...." << endl;
    return false;
  }

  init(bmp.GetWidth(), bmp.GetHeight());
  src = bmp.GetLineArray();
  dest  = get_buffer();

  for (int j=0; j<maxy; j++) {
    for (int i=0; i<maxx; i++) {
      PLBYTE *tmp = src[j];

      if (fmt == vuBMP_GREY) {
	*(dest++) = tmp[i];
	*(dest++) = tmp[i];
	*(dest++) = tmp[i];
      }
      else {
	*(dest++) = tmp[4*i+0];
	*(dest++) = tmp[4*i+1];
	*(dest++) = tmp[4*i+2];
      }
      
    }
  }

  return true;
}
#endif

vuImage vuImage::operator=(const vuImage &other)
{
  if (this == &other) return other;

  int width  = other.getWidth();
  int height = other.getHeight();
  
  init(width, height);

  byte       *dest = get_buffer();
  const byte *src  = other.get_rgb();

  for (int j=0; j<height; j++) {
    for (int i=0; i<width; i++) {
      *(dest++) = *(src++); // red
      *(dest++) = *(src++); // green
      *(dest++) = *(src++); // blue
    }
  }
  return other;
}

vuImage &vuImage::operator+=(vuImage &other)
{
  int width  = this->getWidth();
  int height = this->getHeight();

  if (width != other.getWidth()) {
    // ToDo: should throw an exception
    cerr << "can not add images: widths are different (";
    cerr << width << " vs. " << other.getWidth() << ")" << endl;
    return *this;
  }
  if (height != other.getHeight()) {
    // ToDo: should throw an exception
    cerr << "can not add images: heights are different (";
    cerr << height << " vs. " << other.getHeight() << ")" << endl;
    return *this;
  }

  byte *dest = get_buffer();
  byte *src  = other.get_buffer();

  for (int j=0; j<height; j++) {
    for (int i=0; i<width; i++) {
      *(dest++) += *(src++); // red
      *(dest++) += *(src++); // green
      *(dest++) += *(src++); // blue
    }
  }
  return *this;
}

vuImage &vuImage::operator*=(float scale)
{
  int  width  = this->getWidth();
  int  height = this->getHeight();
  byte *ptr   = get_buffer();

  for (int j=0; j<height; j++) {
    for (int i=0; i<width; i++) {
      byte tmp;

      tmp = (byte)(*ptr * scale); *(ptr++) = tmp; // red
      tmp = (byte)(*ptr * scale); *(ptr++) = tmp; // green
      tmp = (byte)(*ptr * scale); *(ptr++) = tmp; // blue
    }
  }
  return *this;
}
