#ifndef _VUHISTOGRAM_H_
#define _VUHISTOGRAM_H_

#include <iostream>

#include "vuDVector.h"
#include "vuString.h"
#include <vuSimpleTypes.h>

using namespace std;

/** Class to assist in the creation of various Histograms. 

The current implementation just calculates intensity histograms in a 
very unflexible way...

We need a concept for histograms. This is just a quick creation of an
initial class, but is has to be rewritten. The following lines are
just a collection of ideas.

A central histogram class is useful for creation of transfer functions
and for basic image processing (e.g. histogram equalization).

A histogram class should be
    - open for different types of volumes (grid structure)
    - open for different types of data (byte, word, float)? Maybe not.

That means a histogram for intensity distibutions is basically the
same for all kinds of data. Only the way it is created will differ.
To create specific histograms should be the task of the histogram
class. That means if a Laplacian weighted histogram is requested the
histogram class will ask the volume for intensities and derivatives
and create the according statistics. The question is how to apply this
to different kinds of geometry (BCC, Rectilinear, ...). 

To get started we can assume that all data is unimodal of type 'word'.

Histograms for multimodal data are a different problem. Maybe each
type of data (byte, float, vector data) should have an own histogram
class, which could maybe derived from a base class. 

interface to all volumes 
	- allow to ask for local properties
	  such as: intensity, derivative 1. and 2., local variance...
	  What to do to create co-occurrence distributions?
	  (That are 2D histograms saying how often intensityX is close to
	   intensityY. Can be use for threshold determination)
	- traverse volume
	  let histogram class move through the volume and collect statistics
	--> some virtual functions in the volume class?
	  Only advancePosition() would be possible. The other functions would
	  vary in return type.
*/
class vuHistogram {
 public:
    enum HistType { TYPE_INTENSITY=0, TYPE_LAPWEIGHTED, 
	   TYPE_NUMTYPES
    };

    /* Constructor. */
    //vuHistogram();
    /** Specialized constructor. */
    vuHistogram(HistType type = TYPE_INTENSITY) ;
    /** Destructor. */
    virtual ~vuHistogram();

    /** Sets a histogram type. */
    void setType(HistType type);
    HistType getType() { return m_Type; }
    /** Resets the statistics. */
    void reset();
    /** set the initial size of the histogram (256) */
    void setSize(dword size);

    /** This is just a try to implement an intensity histogram creation. */
    void recordIntensity(word intensity);

    //!Interface to the recorded histogram information
    const vuDVector<dword> getHistogram() const
	{ return m_Histogram; }
    //!Return name of type set.
    const char* getTypeName() const;

    //! Write contents of histogram to a stream.
    friend ostream& operator<<(ostream& os, const vuHistogram& hist);
    // Read contents of histogram from a stream.
    //not implemented: friend istream& operator>>(istream& os, vuHistogram& hist);
 protected:
    //! Histogram data
    vuDVector<dword> m_Histogram;
    //! Type of the Histogram
    HistType m_Type;
    // Name of the Histogram
    //m_TypeName has been made static out of class to allow 
};

#endif
