#include "vuHistogram.h"

vuHistogram::vuHistogram( HistType type) 
{
    reset();
    setType(type);
}

vuHistogram::~vuHistogram()
{
}

void vuHistogram::setType(HistType type)
{
    m_Type = type;
    reset();
}

const char* vuHistogram::getTypeName() const
{ 
    //histogram names
    const static char  s_TypeName[][255] =
	{"Intensity", "Isosurface Area"};
    return s_TypeName[(int)m_Type];
}

void vuHistogram::reset()
{
    int i, len = m_Histogram.getLength();
    for(i=0; i<len; i++)
	m_Histogram[i] = 0;
}

void vuHistogram::setSize(dword size)
{
    dword len = m_Histogram.getLength();
    m_Histogram.setSize(size);
    if(size > len)
    {
	dword p;
	for(p = len; p<size; p++)
	    m_Histogram[p] = 0;
    }
}

void vuHistogram::recordIntensity(word intensity)
{
    int len = m_Histogram.getLength();
    if(intensity >= len)
    {
	int p;
	for(p = intensity; p>=len; p--)
	    m_Histogram[p] = 0;
    }
    m_Histogram[intensity]++;
}

ostream& operator<<(ostream& os, const vuHistogram& hist)
{
    dword v;
    dword len = hist.m_Histogram.getLength();
    for(v=0; v<len; v++)
    {
	os << v <<" \t" << hist.m_Histogram[v] << endl;
    }
    return os;
}

