#ifndef _VUCONVEXHULL_H_
#define _VUCONVEXHULL_H_

#include "vuVector.h"
#include "vuDVector.h"

class vuConvexHull 
{
 public:
    vuConvexHull() : m_CHCalculated(false) {};
    
    void setPoints(int npoints, float* plist);
    void addPoint(float x, float y);
    void addPoint(int index, float x, float y);
    void clearPoints();
    int getNPoints() {return m_PList.getLength();};

	// remove corners with angles less than 'angle_th'
	int angleThreshold(float angle_th);
	
	//return list of indices of convex hull
	bool getCHull(vuDVector<int>& indices);
	bool getCHull(int & lenHull, int *indices);
        
private:
    class CHPoint 
	{
    public:
	    CHPoint() {};
	    CHPoint(int _i, float _x, float _y) : x(_x), y(_y), index(_i) {};
		CHPoint(int _i, const vuVector& v) : x(v[0]) , y(v[1]), index(_i) {};
		CHPoint& operator= (const CHPoint & rhs) {
			x = rhs.x;
			y = rhs.y;
			index = rhs.index;
			return *this;
	    }
		vuVector& toVector(vuVector& v) {
			v[0] = x;
			v[1] = y;
			v[2] = 0;
			v[3] = 1;
			return v;
		}
	    float x,y;
	    int index;
	};

    void setPoints(const vuDVector<CHPoint>& plist);
    void addPoint(const CHPoint& p);
    void sortPList();
    void sweepLine();
    void mergeULHulls();
    void calcConvexHull();
	static float knickTest(const CHPoint & b, const CHPoint & q, const CHPoint & r);
            
    vuDVector<CHPoint>	m_PList;
    vuDVector<CHPoint>	m_CHull;
    vuDVector<CHPoint>	m_UHull, m_LHull;
    bool m_CHCalculated;
};


#endif
