#include <iostream>
#include <math.h>

#include "vuConvexHull.h"

void vuConvexHull::setPoints(int npoints, float* plist)
{
    for(int i=0;i<npoints;i++)
    {
	CHPoint p(i,*(plist++),*(plist++));
	m_PList.add(p);
    }
    m_CHCalculated = false;
}

void vuConvexHull::setPoints(const vuDVector<CHPoint>& plist)
{
    int npoints = (int)plist.getLength();
	for(int i=0;i<npoints;i++)
    {
		m_PList.add(plist[i]);
    }
    m_CHCalculated = false;
}

void vuConvexHull::addPoint(const CHPoint& p)
{
    bool isset = false;
	int index = p.index;
    for(int i=0;i<(int)m_PList.getLength();i++)
	if(m_PList[i].index==index)
	{
	    m_PList[i] = p;
	    isset = true;
	    break;
	}
    if(!isset) m_PList.add(p);
    m_CHCalculated = false;
}

void vuConvexHull::addPoint(float x, float y)
{
    m_PList.add(CHPoint(getNPoints(), x, y));
    m_CHCalculated = false;
}

void vuConvexHull::addPoint(int index, float x, float y)
{
    bool isset = false;
    for(int i=0;i<(int)m_PList.getLength();i++)
	if(m_PList[i].index==index)
	{
	    m_PList[i] = CHPoint(index, x, y);
	    isset = true;
	    break;
	}
    if(!isset) m_PList.add(CHPoint(index, x, y));
    m_CHCalculated = false;
}

void vuConvexHull::clearPoints()
{
    m_PList.removeRange(0,m_PList.getLength());
}

bool vuConvexHull::getCHull(vuDVector<int>& indices)
{
    if(!m_CHCalculated) calcConvexHull();
    
    int lenHull = (int)m_CHull.getLength();
    indices.removeAll();

    for(int i=0;i<lenHull;i++)
		indices.add(m_CHull[i].index);
    
    return true;
}

bool vuConvexHull::getCHull(int & lenHull, int *indices)
{
    if((int)m_CHull.getLength() > lenHull) return false;

    if(!m_CHCalculated) calcConvexHull();
    
    lenHull = (int)m_CHull.getLength();
    
    for(int i=0;i<lenHull;i++)
	*(indices++) = m_CHull[i].index;
    
    return true;
}

void vuConvexHull::sortPList()
{
    bool sorted = false;
    for(int n=getNPoints()-1; n>0 && !sorted; n--)
    {
	sorted = true;
	for(int i=0;i<n;i++)
	{
	    if(m_PList[i].x > m_PList[i+1].x)
	    {
		CHPoint t = m_PList[i];
		m_PList[i] = m_PList[i+1];
		m_PList[i+1] = t;
		sorted = false;
	    }
	}
    }
}

void vuConvexHull::sweepLine()
{
    m_UHull.removeAll();
    m_LHull.removeAll();
    m_UHull.add(m_PList[0]);
    m_LHull.add(m_PList[0]);
    for(int i=1;i<getNPoints();i++)
    {
	while(m_UHull.getLength()>1 && 
	      knickTest(m_UHull[m_UHull.getLength()-2],
			m_UHull[m_UHull.getLength()-1],m_PList[i]) > 0.0)
	    m_UHull.remove(m_UHull.getLength()-1);

	while(m_LHull.getLength()>1 && 
	      knickTest(m_LHull[m_LHull.getLength()-2],
			m_LHull[m_LHull.getLength()-1],m_PList[i]) < 0.0)
	    m_LHull.remove(m_LHull.getLength()-1);
	m_UHull.add(m_PList[i]);
	m_LHull.add(m_PList[i]);
    }
}

float vuConvexHull::knickTest(const CHPoint & b, const CHPoint & q, const CHPoint & r)
{
    return (q.x-b.x)*(r.y-b.y) - (q.y-b.y)*(r.x-b.x);
}

void vuConvexHull::mergeULHulls()
{
    m_CHull.removeAll();
	int i;
    for(i=0;i<(int)m_LHull.getLength();i++)
		m_CHull.add(m_LHull[i]);
    for(i=m_UHull.getLength()-2;i>0;i--)
		m_CHull.add(m_UHull[i]);
}

void vuConvexHull::calcConvexHull()
{
    sortPList();
    sweepLine();
    mergeULHulls();
    m_CHCalculated = true;
}

int vuConvexHull::angleThreshold(float angle_th)
{
	int nrem=1;
	if(!m_CHCalculated) calcConvexHull();
	if(m_CHull.getLength()<4) return 0;

	float cosa = cos(angle_th*M_PI/180);
	vuVector last;
	m_CHull[m_CHull.getLength()-1].toVector(last);
	for(int i=0;i<(int)m_CHull.getLength();i++)
	{
		vuVector next;
		if (i==(int)m_CHull.getLength()-1) m_CHull[0].toVector(next);
		else m_CHull[i+1].toVector(next);
		vuVector c;
		m_CHull[i].toVector(c);
		vuVector a = c;
		a-=last;
		vuVector b = next;
		b-= c;
		if (a.normalize() == 0.0 || 
			b.normalize() == 0.0)
		{
			last = c;
		} else {
			//dot product bigger than cosine(angle)?
			if (a.dot(b)>cosa) {
				m_CHull.remove(i--);
				nrem++;
			} else last = c;
		}
	}
	return nrem;
}

