/*! This class offers command line parameter parsing.

    Following three schemes are supported:
         -t
         --type
         --type=someValue
*/

#include "vuString.h"

class vuCommandLineTool
{
public:
  // constructor
  vuCommandLineTool();

  // default constructor
  vuCommandLineTool(int argc, const char ** argv);

  // copy constructor
  vuCommandLineTool(const vuCommandLineTool &other);

  ~vuCommandLineTool();

  /*! returns true, if param exists, otherwise false
      \note Example: hasPrameter("-t"), or hasParameter("--type") */
  bool hasParameter(const char *param);
  //! returns the string value for a param
  vuString stringForParameter(const char *param);
  //! returns the float value for a param
  float floatForParameter(const char *param);
  //! returns the int value for a param
  int intForParameter(const char *param);

  /*! returns the number of non parameters (the ones which don't have the
      prefix '-') AT THE END of argv.

      \note A "non parameter" between normal parameters will be ignored
            and is considered to be not valid.
  */
  word numberOfNonParameters();
  /*! returns the number of non parameters (the ones which don't have the
      prefix '-') AT THE END of argv.

      \note A "non parameter" between normal parameters will be ignored and
            is considered to be not valid. The parameter isValid tracks this
            information.
  */
  word numberOfNonParameters(bool &isValid);

  vuString getNonParameter(const dword idx);

  //! get the ith argument of the command line
  vuString getArgument(word i);

  //! returns true if file exists, otherwise false
  bool fileExists(const vuString &fileName);
  
  /*! returns the lastPathComponent of the 0th argument of argv
      (usually the toolname)
  */
  vuString toolName();

private:
  int      m_argc;  // length of command line
  vuString *m_argv; // command line

  int indexForParamter(const vuString &param);
};
